/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.util.List;
import java.util.Properties;
import org.brandao.brutos.ActionResolver;
import org.brandao.brutos.ActionType;
import org.brandao.brutos.ApplicationContext;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.CodeGenerator;
import org.brandao.brutos.ComponentRegistry;
import org.brandao.brutos.ComponentRegistryAdapter;
import org.brandao.brutos.ConfigurableApplicationContext;
import org.brandao.brutos.ConfigurableRenderView;
import org.brandao.brutos.ConfigurableRequestParser;
import org.brandao.brutos.ConfigurableViewResolver;
import org.brandao.brutos.Configuration;
import org.brandao.brutos.ControllerManager;
import org.brandao.brutos.ControllerManagerImp;
import org.brandao.brutos.ControllerResolver;
import org.brandao.brutos.DataType;
import org.brandao.brutos.DefaultActionResolver;
import org.brandao.brutos.DefaultControllerResolver;
import org.brandao.brutos.DefaultMvcRequestFactory;
import org.brandao.brutos.DefaultMvcResponseFactory;
import org.brandao.brutos.DefaultRenderView;
import org.brandao.brutos.DefaultViewResolver;
import org.brandao.brutos.DispatcherType;
import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.FetchType;
import org.brandao.brutos.InterceptorManager;
import org.brandao.brutos.InterceptorManagerImp;
import org.brandao.brutos.Invoker;
import org.brandao.brutos.MvcRequest;
import org.brandao.brutos.MvcRequestFactory;
import org.brandao.brutos.MvcResponse;
import org.brandao.brutos.MvcResponseFactory;
import org.brandao.brutos.ObjectFactory;
import org.brandao.brutos.ProxyFactory;
import org.brandao.brutos.RenderView;
import org.brandao.brutos.RequestParser;
import org.brandao.brutos.RequestParserImp;
import org.brandao.brutos.RequestParserListenerFactory;
import org.brandao.brutos.RequestParserListenerFactoryImp;
import org.brandao.brutos.RequestProvider;
import org.brandao.brutos.ResponseProvider;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.Scopes;
import org.brandao.brutos.TypeManager;
import org.brandao.brutos.ValidatorFactory;
import org.brandao.brutos.ViewResolver;
import org.brandao.brutos.io.DefaultResourceLoader;
import org.brandao.brutos.javassist.JavassistCodeGenerator;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.scope.ControllerScope;
import org.brandao.brutos.scope.SingletonScope;
import org.brandao.brutos.scope.ThreadScope;
import org.brandao.brutos.validator.JSR303ValidatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext {
    protected Logger logger;
    protected ObjectFactory objectFactory;
    protected InterceptorManager interceptorManager;
    protected ControllerManager controllerManager;
    protected ConfigurableRenderView renderView;
    protected Invoker invoker;
    protected Properties configuration;
    protected LoggerProvider loggerProvider;
    protected ControllerResolver controllerResolver;
    protected ActionResolver actionResolver;
    protected MvcResponseFactory responseFactory;
    protected MvcRequestFactory requestFactory;
    protected Scopes scopes;
    private ConfigurableViewResolver viewResolver;
    private ValidatorFactory validatorFactory;
    protected CodeGenerator codeGenerator;
    private ApplicationContext parent;
    protected TypeManager typeManager;
    protected RequestParserListenerFactory requestParserListenerFactory;
    protected ConfigurableRequestParser requestParser;
    protected DispatcherType dispatcherType;
    protected boolean automaticViewResolver;
    protected EnumerationType enumerationType;
    protected ScopeType scopeType;
    protected String temporalProperty;
    protected String actionParameterName;
    protected ActionType actionType;
    protected FetchType fetchType;
    protected boolean mappingException;

    public AbstractApplicationContext() {
        this((ApplicationContext)null);
    }

    public AbstractApplicationContext(ApplicationContext parent) {
        this.parent = parent;
        this.configuration = parent == null ? new Configuration() : new Configuration(parent.getConfiguration());
        this.scopes = new Scopes();
    }

    protected void initInstances() {
        this.objectFactory = this.getNewObjectFactory();
        this.interceptorManager = this.getNewInterceptorManager();
        this.controllerResolver = this.getNewControllerResolver();
        this.actionResolver = this.getNewMethodResolver();
        this.requestFactory = this.getMvcRequestFactory();
        this.responseFactory = this.getMvcResponseFactory();
        this.validatorFactory = this.getNewValidatorFactory();
        this.viewResolver = this.getNewViewResolver();
        this.controllerManager = this.getNewControllerManager();
        this.renderView = this.getNewRenderView();
        this.codeGenerator = this.getNewCodeGenerator();
        this.requestParser = this.getInitRequestParser();
        this.typeManager = this.getNewTypeManager();
        this.requestParserListenerFactory = this.getRequestParserListenerFactory();
        this.dispatcherType = this.getInitDispatcherType();
        this.automaticViewResolver = this.getInitAutomaticViewResolver();
        this.enumerationType = this.getInitEnumerationType();
        this.scopeType = this.getInitScopeType();
        this.temporalProperty = this.getInitTemporalProperty();
        this.automaticViewResolver = this.getInitAutomaticViewResolver();
        this.actionParameterName = this.getInitActionParameterName();
        this.actionType = this.getInitActionType();
        this.fetchType = this.getInitFetchType();
        this.invoker = this.getNewInvoker();
        this.mappingException = this.getInitMappingException();
    }

    protected void initInvoker() {
        this.invoker.flush();
    }

    protected void initTypes() {
    }

    protected void initScopes() {
        this.getScopes().register(ScopeType.SINGLETON.toString(), new SingletonScope());
        this.getScopes().register(ScopeType.THREAD.toString(), new ThreadScope());
        this.getScopes().register(ScopeType.PARAM.toString(), this.getScopes().get(ScopeType.THREAD));
        this.getScopes().register(ScopeType.REQUEST.toString(), this.getScopes().get(ScopeType.THREAD));
        this.getScopes().register(ScopeType.CONTROLLER.toString(), new ControllerScope());
    }

    protected void initComponents() {
        List<Controller> controllers = this.controllerManager.getControllers();
        for (Controller controller : controllers) {
            controller.flush();
        }
    }

    protected void initLogger() {
        this.logger = LoggerProvider.getCurrentLoggerProvider().getLogger(this.getClass());
    }

    protected abstract void loadDefinitions(ComponentRegistry var1);

    protected ControllerResolver getNewControllerResolver() {
        try {
            Class<?> clazz = ClassUtil.get(this.configuration.getProperty("org.brandao.brutos.controller.class", DefaultControllerResolver.class.getName()));
            return (ControllerResolver)ClassUtil.getInstance(clazz);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected MvcResponseFactory getMvcResponseFactory() {
        try {
            Class<?> clazz = ClassUtil.get(this.configuration.getProperty("org.brandao.brutos.controller.response_factory", DefaultMvcResponseFactory.class.getName()));
            return (MvcResponseFactory)ClassUtil.getInstance(clazz);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected MvcRequestFactory getMvcRequestFactory() {
        try {
            Class<?> clazz = ClassUtil.get(this.configuration.getProperty("org.brandao.brutos.controller.request_factory", DefaultMvcRequestFactory.class.getName()));
            return (MvcRequestFactory)ClassUtil.getInstance(clazz);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected ActionResolver getNewMethodResolver() {
        try {
            Class<?> clazz = ClassUtil.get(this.configuration.getProperty("org.brandao.brutos.controller.action_resolver", DefaultActionResolver.class.getName()));
            return (ActionResolver)ClassUtil.getInstance(clazz);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected ControllerManager getNewControllerManager() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.manager.controller", ControllerManagerImp.class.getName());
            Class<?> clazz = ClassUtil.get(className);
            ControllerManager instance = (ControllerManager)ClassUtil.getInstance(clazz);
            instance.setInterceptorManager(this.interceptorManager);
            instance.setValidatorFactory(this.validatorFactory);
            instance.setParent(this.parent == null ? null : ((ConfigurableApplicationContext)this.parent).getControllerManager());
            instance.setApplicationContext(this);
            return instance;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected InterceptorManager getNewInterceptorManager() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.manager.interceptor", InterceptorManagerImp.class.getName());
            Class<?> clazz = ClassUtil.get(className);
            InterceptorManager instance = (InterceptorManager)ClassUtil.getInstance(clazz);
            instance.setParent(this.parent == null ? null : ((ConfigurableApplicationContext)this.parent).getInterceptorManager());
            return instance;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected ObjectFactory getNewObjectFactory() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.object_factory", "org.brandao.brutos.cdi.JSR299ObjectFactory");
            Class<?> clazz = ClassUtil.get(className);
            ObjectFactory instance = (ObjectFactory)ClassUtil.getInstance(clazz);
            instance.configure(this.configuration);
            return instance;
        }
        catch (BrutosException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }

    protected ValidatorFactory getNewValidatorFactory() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.validator_factory", JSR303ValidatorFactory.class.getName());
            Class<?> clazz = ClassUtil.get(className);
            ValidatorFactory instance = (ValidatorFactory)ClassUtil.getInstance(clazz);
            instance.configure(this.configuration);
            return instance;
        }
        catch (BrutosException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }

    protected CodeGenerator getNewCodeGenerator() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.code_generator", JavassistCodeGenerator.class.getName());
            Class<?> clazz = ClassUtil.get(className);
            CodeGenerator instance = (CodeGenerator)ClassUtil.getInstance(clazz);
            instance.configure(this.configuration);
            return instance;
        }
        catch (BrutosException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }

    protected ConfigurableRenderView getNewRenderView() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.render_view", DefaultRenderView.class.getName());
            Class<?> clazz = ClassUtil.get(className);
            ConfigurableRenderView instance = (ConfigurableRenderView)ClassUtil.getInstance(clazz);
            instance.setDefaultRenderViewType(this.getInitResponseType());
            return instance;
        }
        catch (BrutosException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }

    protected Invoker getNewInvoker() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.invoker", "org.brandao.brutos.Invoker");
            Class<?> clazz = ClassUtil.get(className);
            Invoker instance = (Invoker)ClassUtil.getInstance(clazz);
            instance.setObjectFactory(this.objectFactory);
            instance.setActionResolver(this.actionResolver);
            instance.setControllerManager(this.controllerManager);
            instance.setApplicationContext(this);
            instance.setRenderView(this.renderView);
            instance.setRequestParser(this.requestParser);
            instance.setRequestParserListener(this.requestParserListenerFactory.getNewListener());
            return instance;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected ConfigurableViewResolver getNewViewResolver() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.view.resolver", DefaultViewResolver.class.getName());
            ConfigurableViewResolver instance = (ConfigurableViewResolver)ClassUtil.getInstance(ClassUtil.get(className));
            instance.setApplicationContext(this);
            instance.setIndexName(this.getInitViewIndex());
            instance.setPrefix(this.getInitViewPrefix());
            instance.setSeparator(this.getInitSeparator());
            instance.setSuffix(this.getInitViewSuffix());
            return instance;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected TypeManager getNewTypeManager() {
        try {
            String className = this.configuration.getProperty("org.brandao.brutos.type.manager", "org.brandao.brutos.type.TypeManagerImp");
            TypeManager tmp = (TypeManager)ClassUtil.getInstance(ClassUtil.get(className));
            return tmp;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected RequestParserListenerFactory getRequestParserListenerFactory() {
        try {
            Properties config = this.getConfiguration();
            String uploadListenerFactoryName = config.getProperty("org.brandao.brutos.request.listener_factory", RequestParserListenerFactoryImp.class.getName());
            Class<?> ulfClass = Class.forName(uploadListenerFactoryName, true, Thread.currentThread().getContextClassLoader());
            return (RequestParserListenerFactory)ClassUtil.getInstance(ulfClass);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected ConfigurableRequestParser getInitRequestParser() {
        try {
            Properties config = this.getConfiguration();
            String clazz = config.getProperty("org.brandao.brutos.request.parser", RequestParserImp.class.getName());
            Class<?> ulfClass = Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
            ConfigurableRequestParser instance = (ConfigurableRequestParser)ClassUtil.getInstance(ulfClass);
            instance.setDefaultParserType(this.getInitRequestType());
            instance.setCodeGenerator(this.codeGenerator);
            return instance;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected DataType getInitRequestType() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.request.default_type");
            return DataType.valueOf(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected DataType getInitResponseType() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.response.default_type");
            return DataType.valueOf(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected DispatcherType getInitDispatcherType() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.view.dispatcher_type", DispatcherType.FORWARD.toString());
            return DispatcherType.valueOf(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected boolean getInitAutomaticViewResolver() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.view.auto", Boolean.TRUE.toString());
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected EnumerationType getInitEnumerationType() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.enumeration_type", EnumerationType.AUTO.toString());
            return EnumerationType.valueOf(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected ScopeType getInitScopeType() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.scope_type", ScopeType.PARAM.toString());
            return ScopeType.valueOf(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected String getInitTemporalProperty() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.temporal_property", "yyyy-MM-dd");
            return value;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected String getInitViewPrefix() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.view.prefix", "views.");
            return value;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected String getInitViewSuffix() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.view.suffix", "");
            return value;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected String getInitViewIndex() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.view.index", "index");
            return value;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected String getInitSeparator() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.view.separator", ".");
            return value;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected String getInitActionParameterName() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.action.parameter_name", "invoke");
            return value;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected ActionType getInitActionType() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.action_strategy", "parameter");
            return ActionType.valueOf(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected FetchType getInitFetchType() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.fetch_type", "eager");
            return FetchType.valueOf(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    protected boolean getInitMappingException() {
        try {
            Properties config = this.getConfiguration();
            String value = config.getProperty("org.brandao.brutos.mapping.exception", "eager");
            return "true".equals(value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    @Override
    public void destroy() {
        this.objectFactory.destroy();
        this.codeGenerator.destroy();
        this.validatorFactory.destroy();
        this.scopes.clear();
        this.actionResolver = null;
        this.codeGenerator = null;
        this.configuration = null;
        this.controllerManager = null;
        this.controllerResolver = null;
        this.interceptorManager = null;
        this.invoker = null;
        this.objectFactory = null;
        this.loggerProvider = null;
        this.requestFactory = null;
        this.responseFactory = null;
        this.validatorFactory = null;
        this.viewResolver = null;
    }

    @Override
    public void setActionParameterName(String name) {
        this.actionParameterName = name;
    }

    @Override
    public String getActionParameterName() {
        return this.actionParameterName;
    }

    @Override
    public void setActionType(ActionType value) {
        this.actionType = value;
    }

    @Override
    public ActionType getActionType() {
        return this.actionType;
    }

    @Override
    public String getViewPrefix() {
        return this.viewResolver.getPrefix();
    }

    @Override
    public void setViewPrefix(String value) {
        this.viewResolver.setPrefix(value);
    }

    @Override
    public String getViewSuffix() {
        return this.viewResolver.getSuffix();
    }

    @Override
    public void setViewSuffix(String value) {
        this.viewResolver.setSuffix(value);
    }

    @Override
    public String getViewIndex() {
        return this.viewResolver.getIndexName();
    }

    @Override
    public void setViewIndex(String value) {
        this.viewResolver.setIndexName(value);
    }

    @Override
    public String getSeparator() {
        return this.viewResolver.getSeparator();
    }

    @Override
    public void setSeparator(String value) {
        this.viewResolver.setSeparator(value);
    }

    @Override
    public void setAutomaticViewResolver(boolean value) {
        this.automaticViewResolver = value;
    }

    @Override
    public void setTemporalProperty(String value) {
        this.temporalProperty = value;
    }

    @Override
    public boolean isAutomaticViewResolver() {
        return this.automaticViewResolver;
    }

    @Override
    public String getTemporalProperty() {
        return this.temporalProperty;
    }

    @Override
    public void setScopeType(ScopeType value) {
        this.scopeType = value;
    }

    @Override
    public ScopeType getScopeType() {
        return this.scopeType;
    }

    @Override
    public void setEnumerationType(EnumerationType value) {
        this.enumerationType = value;
    }

    @Override
    public EnumerationType getEnumerationType() {
        return this.enumerationType;
    }

    @Override
    public void setDispatcherType(DispatcherType value) {
        this.dispatcherType = value;
    }

    @Override
    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    @Override
    public void setRequestType(DataType value) {
        this.requestParser.setDefaultParserType(value);
    }

    @Override
    public DataType getRequestType() {
        return this.requestParser.getDefaultParserType();
    }

    @Override
    public void setResponseType(DataType value) {
        this.renderView.setDefaultRenderViewType(value);
    }

    @Override
    public DataType getResponseType() {
        return this.renderView.getDefaultRenderViewType();
    }

    @Override
    public Properties getConfiguration() {
        return this.configuration;
    }

    @Override
    public LoggerProvider getLoggerProvider() {
        return this.loggerProvider;
    }

    @Override
    public MvcResponse getMvcResponse() {
        return ResponseProvider.getResponse();
    }

    @Override
    public MvcRequest getMvcRequest() {
        return RequestProvider.getRequest();
    }

    @Override
    public Scopes getScopes() {
        return this.scopes;
    }

    @Override
    public MvcRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public MvcResponseFactory getResponseFactory() {
        return this.responseFactory;
    }

    protected void setControllerResolver(ControllerResolver controllerResolver) {
        this.controllerResolver = controllerResolver;
    }

    @Override
    public void setInterceptorManager(InterceptorManager interceptorManager) {
        this.interceptorManager = interceptorManager;
    }

    @Override
    public void setRenderView(ConfigurableRenderView renderView) {
        this.renderView = renderView;
    }

    @Override
    public RenderView getRenderView() {
        return this.renderView;
    }

    @Override
    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    @Override
    public Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public void setInvoker(Invoker value) {
        this.invoker = value;
    }

    @Override
    public void setConfiguration(Properties config) {
        this.configuration = config;
    }

    @Override
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public InterceptorManager getInterceptorManager() {
        return this.interceptorManager;
    }

    @Override
    public FetchType getFetchType() {
        return this.fetchType;
    }

    @Override
    public ControllerManager getControllerManager() {
        return this.controllerManager;
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public ControllerResolver getControllerResolver() {
        return this.controllerResolver;
    }

    @Override
    public ActionResolver getActionResolver() {
        return this.actionResolver;
    }

    @Override
    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    @Override
    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    @Override
    public void setFetchType(FetchType value) {
        this.fetchType = value;
    }

    @Override
    public ViewResolver getViewResolver() {
        return this.viewResolver;
    }

    @Override
    public void setViewResolver(ConfigurableViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    @Override
    public void setRequestParser(ConfigurableRequestParser value) {
        this.requestParser = value;
    }

    @Override
    public RequestParser getRequestParser() {
        return this.requestParser;
    }

    @Override
    public boolean isMappingException() {
        return this.mappingException;
    }

    @Override
    public void setMappingException(boolean mappingException) {
        this.mappingException = mappingException;
    }

    @Override
    public Object getController(Class<?> clazz) {
        Controller controller = this.controllerManager.getController(clazz);
        if (controller == null) {
            throw new BrutosException(String.format("controller not configured: %s", clazz.getName()));
        }
        Object resource = controller.getInstance(this.objectFactory);
        ProxyFactory proxyFactory = this.codeGenerator.getProxyFactory(controller.getClassType());
        Object proxy = proxyFactory.getNewProxy(resource, controller, this, this.invoker);
        return proxy;
    }

    @Override
    public void setParent(ApplicationContext applicationContext) {
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            throw new IllegalArgumentException("expected: instance of " + ConfigurableApplicationContext.class.getName());
        }
        this.parent = applicationContext;
        this.controllerManager.setParent(((ConfigurableApplicationContext)applicationContext).getControllerManager());
        this.interceptorManager.setParent(((ConfigurableApplicationContext)applicationContext).getInterceptorManager());
    }

    @Override
    public ApplicationContext getParent() {
        return this.parent;
    }

    @Override
    public Object getBean(Class<?> clazz) {
        return this.objectFactory.getBean(clazz);
    }

    @Override
    public Object getBean(String name) {
        return this.objectFactory.getBean(name);
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public boolean isStandardType(Class<?> clazz) {
        return this.typeManager.isStandardType(clazz);
    }

    @Override
    public void flush() {
        this.initLogger();
        this.initInstances();
        this.initScopes();
        this.initTypes();
        this.initInvoker();
        this.loadDefinitions(new ComponentRegistryAdapter(this));
        this.initComponents();
    }
}

