/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import org.brandao.brutos.DispatcherType;
import org.brandao.brutos.MvcRequest;
import org.brandao.brutos.MvcResponse;
import org.brandao.brutos.RenderViewType;
import org.brandao.brutos.RequestInstrument;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.Scopes;
import org.brandao.brutos.StackRequestElement;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.mapping.ResultAction;
import org.brandao.brutos.mapping.ThrowableSafeData;
import org.brandao.brutos.scope.Scope;
import org.brandao.brutos.type.Type;

public abstract class AbstractRenderView
implements RenderViewType {
    protected abstract void show(RequestInstrument var1, String var2, DispatcherType var3);

    private void showView(RequestInstrument requestInstrument, String view, DispatcherType dispatcherType) {
        requestInstrument.setHasViewProcessed(true);
        this.show(requestInstrument, view, dispatcherType);
    }

    private void showView(RequestInstrument requestInstrument, StackRequestElement stackRequestElement, Type type) {
        requestInstrument.setHasViewProcessed(true);
        type.show(stackRequestElement.getResponse(), stackRequestElement.getResultAction());
    }

    public void show(MvcRequest request, MvcResponse response) {
        RequestInstrument requestInstrument = request.getRequestInstrument();
        StackRequestElement stackRequestElement = request.getStackRequestElement();
        if (requestInstrument.isHasViewProcessed()) {
            return;
        }
        Scopes scopes = requestInstrument.getContext().getScopes();
        Scope requestScope = scopes.get(ScopeType.REQUEST.toString());
        Action method = stackRequestElement.getAction() == null ? null : stackRequestElement.getAction().getMethodForm();
        ThrowableSafeData throwableSafeData = stackRequestElement.getThrowableSafeData();
        Throwable objectThrow = stackRequestElement.getObjectThrow();
        if (throwableSafeData != null) {
            if (throwableSafeData.getParameterName() != null) {
                requestScope.put(throwableSafeData.getParameterName(), objectThrow);
            }
            if (throwableSafeData.getView() != null) {
                this.showView(requestInstrument, throwableSafeData.getView(), throwableSafeData.getDispatcher());
                return;
            }
        }
        if (stackRequestElement.getView() != null) {
            this.showView(requestInstrument, stackRequestElement.getView(), stackRequestElement.getDispatcherType());
            return;
        }
        if (method != null) {
            ResultAction resultAction = method.getResultAction();
            if (resultAction.getType() != null) {
                String var = resultAction.getName() == null ? "result" : resultAction.getName();
                requestScope.put(var, stackRequestElement.getResultAction());
                if (method.isReturnRendered() || resultAction.getType().isAlwaysRender()) {
                    this.showView(requestInstrument, stackRequestElement, resultAction.getType());
                    return;
                }
            }
            if (method.getView() != null) {
                this.showView(requestInstrument, method.getView(), method.getDispatcherType());
                return;
            }
        }
        if (stackRequestElement.getController().getView() != null) {
            this.showView(requestInstrument, stackRequestElement.getController().getView(), stackRequestElement.getController().getDispatcherType());
        } else if (method != null && method.getResultAction().getType() != null) {
            this.showView(requestInstrument, stackRequestElement, method.getResultAction().getType());
        }
    }
}

