/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.brandao.brutos.CodeGenerator;
import org.brandao.brutos.ConfigurableRequestParser;
import org.brandao.brutos.DataType;
import org.brandao.brutos.MutableMvcRequest;
import org.brandao.brutos.MutableRequestParserEvent;
import org.brandao.brutos.ParserContentType;
import org.brandao.brutos.RequestParserException;

public abstract class AbstractRequestParser
implements ConfigurableRequestParser {
    protected Map<DataType, ParserContentType> parsers = new HashMap<DataType, ParserContentType>();
    protected DataType defaultDataType;
    protected CodeGenerator codeGenerator;

    public void parserContentType(MutableMvcRequest request, DataType dataType, Properties config, MutableRequestParserEvent requestParserInfo, CodeGenerator codeGenerator) throws RequestParserException {
        ParserContentType parser;
        if (dataType == null) {
            if (this.defaultDataType == null) {
                return;
            }
            dataType = this.defaultDataType;
        }
        if ((parser = this.parsers.get(dataType)) == null) {
            throw new RequestParserException("not found: " + dataType.getName());
        }
        parser.parserContentType(request, requestParserInfo, this.codeGenerator, config);
    }

    public synchronized void registerParser(DataType dataType, ParserContentType parser) throws RequestParserException {
        if (this.parsers.containsKey(dataType)) {
            throw new RequestParserException("Parser already registered: " + dataType.getName());
        }
        this.parsers.put(dataType, parser);
    }

    public synchronized void removeParser(DataType value) throws RequestParserException {
        if (!this.parsers.containsKey(value)) {
            throw new RequestParserException("Parser not registered: " + value.getName());
        }
        this.parsers.remove(value);
    }

    public boolean contains(DataType dataType) {
        return this.parsers.containsKey(dataType);
    }

    public void setDefaultParserType(DataType dataType) throws RequestParserException {
        this.defaultDataType = dataType;
    }

    public DataType getDefaultParserType() throws RequestParserException {
        return this.defaultDataType;
    }

    public void setCodeGenerator(CodeGenerator value) {
        this.codeGenerator = value;
    }

    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }
}

