/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import org.brandao.brutos.BeanBuilder;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ConfigurableApplicationContext;
import org.brandao.brutos.Configuration;
import org.brandao.brutos.ControllerBuilder;
import org.brandao.brutos.DataType;
import org.brandao.brutos.DispatcherType;
import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.ParameterBuilder;
import org.brandao.brutos.ParametersBuilder;
import org.brandao.brutos.RestrictionBuilder;
import org.brandao.brutos.ResultActionBuilder;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.ValidatorFactory;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.mapping.ActionID;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.MappingException;
import org.brandao.brutos.mapping.MetaBean;
import org.brandao.brutos.mapping.ParameterAction;
import org.brandao.brutos.mapping.ResultAction;
import org.brandao.brutos.mapping.StringUtil;
import org.brandao.brutos.mapping.ThrowableSafeData;
import org.brandao.brutos.type.ObjectType;
import org.brandao.brutos.type.Type;
import org.brandao.brutos.type.TypeUtil;
import org.brandao.brutos.type.UnknownTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionBuilder
extends RestrictionBuilder {
    protected Controller controller;
    protected Action action;
    protected ValidatorFactory validatorFactory;
    protected ControllerBuilder controllerBuilder;
    protected ConfigurableApplicationContext applicationContext;
    protected ParametersBuilder parametersBuilder;

    public ActionBuilder(ActionBuilder actionBuilder) {
        this(actionBuilder.action, actionBuilder.controller, actionBuilder.validatorFactory, actionBuilder.controllerBuilder, actionBuilder.applicationContext);
    }

    public ActionBuilder(Action action, Controller controller, ValidatorFactory validatorFactory, ControllerBuilder controllerBuilder, ConfigurableApplicationContext applicationContext) {
        super(action.getResultValidator().getConfiguration());
        this.controller = controller;
        this.action = action;
        this.validatorFactory = validatorFactory;
        this.controllerBuilder = controllerBuilder;
        this.applicationContext = applicationContext;
        this.parametersBuilder = new ParametersBuilder(controller, action, validatorFactory, controllerBuilder, applicationContext);
    }

    public ActionBuilder addAlias(String id) {
        if (StringUtil.isEmpty(id = StringUtil.adjust(id))) {
            throw new MappingException("action id cannot be empty");
        }
        ActionID actionId = new ActionID(id);
        return this.addAlias(actionId);
    }

    protected ActionBuilder addAlias(ActionID id) {
        if (this.controller.getActionById(id) != null) {
            throw new MappingException("duplicate action: " + id);
        }
        this.action.getAlias().add(id);
        this.controller.addAction(id, this.action);
        return this;
    }

    public ActionBuilder removeAlias(String id) {
        if (StringUtil.isEmpty(id = StringUtil.adjust(id))) {
            throw new MappingException("action id cannot be empty");
        }
        ActionID actionId = new ActionID(id);
        if (this.controller.getActionById(actionId) != null) {
            throw new MappingException("duplicate action: " + id);
        }
        return this.removeAlias(actionId);
    }

    public ActionBuilder removeAlias(ActionID id) {
        if (this.controller.getAction(id) != null) {
            throw new MappingException("action alias not found: " + id);
        }
        this.action.getAlias().remove(id);
        this.controller.removeAction(id);
        return this;
    }

    public ParametersBuilder buildParameters() {
        return this.parametersBuilder;
    }

    public ActionBuilder addThrowable(Class<?> target, String id) {
        return this.addThrowable(target, null, false, id, null);
    }

    public ActionBuilder addThrowable(Class<?> target, String view, boolean resolvedView, String id, DispatcherType dispatcher) {
        return this.addThrowable(target, view, id, dispatcher, resolvedView);
    }

    public ActionBuilder addThrowable(Class<?> target, String view, String id, DispatcherType dispatcher, boolean resolvedView) {
        view = StringUtil.adjust(view);
        id = StringUtil.isEmpty(id) ? "exception" : StringUtil.adjust(id);
        String originalView = view;
        view = resolvedView ? view : this.applicationContext.getViewResolver().getView(this.controllerBuilder, this, target, view);
        DispatcherType dispatcherType = dispatcher = dispatcher == null ? this.applicationContext.getDispatcherType() : dispatcher;
        if (target == null) {
            throw new MappingException("target is required: " + this.controller.getClassType().getName());
        }
        if (!Throwable.class.isAssignableFrom(target)) {
            throw new MappingException("target is not allowed: " + target.getName());
        }
        if (this.action.getThrowsSafeOnAction(target) != null) {
            throw new MappingException("the exception has been added on action: " + target.getSimpleName());
        }
        ThrowableSafeData thr = new ThrowableSafeData();
        thr.setParameterName(id);
        thr.setTarget(target);
        thr.setView(view);
        thr.setOriginalView(originalView);
        thr.setResolvedView(resolvedView);
        thr.setRedirect(false);
        thr.setDispatcher(dispatcher);
        this.action.setThrowsSafe(thr);
        return this;
    }

    public ControllerBuilder getControllerBuilder() {
        return this.controllerBuilder;
    }

    public String getName() {
        return this.action.getName();
    }

    public ActionBuilder setView(String view, boolean resolvedView) {
        view = resolvedView ? view : this.applicationContext.getViewResolver().getView(this.controllerBuilder, this, null, view);
        this.action.setView(view);
        this.action.setResolvedView(resolvedView);
        return this;
    }

    public String getView() {
        return this.action.getView();
    }

    public ActionBuilder setDispatcherType(String value) {
        if (StringUtil.isEmpty(value = StringUtil.adjust(value))) {
            throw new BrutosException("invalid dispatcher type");
        }
        this.setDispatcherType(DispatcherType.valueOf(value));
        return this;
    }

    public ActionBuilder setDispatcherType(DispatcherType value) {
        this.action.setDispatcherType(value);
        return this;
    }

    public DispatcherType getDispatcherType() {
        return this.action.getDispatcherType();
    }

    public ActionBuilder setExecutor(String value) {
        value = StringUtil.adjust(value);
        this.action.setExecutor(value);
        return this;
    }

    public String getExecutor() {
        return this.action.getExecutor();
    }

    public ActionBuilder setResult(String value) {
        value = StringUtil.adjust(value);
        this.action.getResultAction().setName(value);
        return this;
    }

    public String getResult() {
        return this.action.getResultAction().getName();
    }

    public ActionBuilder setResultRendered(boolean value) {
        this.action.setReturnRendered(value);
        return this;
    }

    public boolean isResultRendered() {
        return this.action.isReturnRendered();
    }

    public int getParametersSize() {
        return this.action.getParamterSize();
    }

    public ParameterBuilder getParameter(int index) {
        ParameterAction param = this.action.getParameter(index);
        return new ParameterBuilder(param, this.parametersBuilder, this.validatorFactory);
    }

    public ActionBuilder addRequestType(DataType value) {
        this.action.getRequestTypes().add(value);
        return this;
    }

    public ActionBuilder removeRequestType(DataType value) {
        this.action.getRequestTypes().remove(value);
        return this;
    }

    public ActionBuilder addResponseType(DataType value) {
        this.action.getResponseTypes().add(value);
        return this;
    }

    public ActionBuilder removeResponseType(DataType value) {
        this.action.getResponseTypes().remove(value);
        return this;
    }

    public ResultActionBuilder setResultAction(String name, EnumerationType enumProperty, Class<?> classType) {
        return this.setResultAction(name, enumProperty, null, null, null, null, false, classType);
    }

    public ResultActionBuilder setNullresultAction() {
        return this.setResultAction(null, null, null, null, null, null, false, null);
    }

    public ResultActionBuilder setResultAction(String name, String temporalProperty, Class<?> classType) {
        return this.setResultAction(name, null, temporalProperty, null, null, null, false, classType);
    }

    public ResultActionBuilder setResultAction(String name, Type typeDef) {
        return this.setResultAction(name, null, null, null, typeDef, null, false, typeDef.getClassType());
    }

    public ResultActionBuilder setResultAction(String name, Class<?> classType) {
        return this.setResultAction(name, null, null, null, null, null, false, classType);
    }

    public ResultActionBuilder setResultActionMapping(String mapping, Class<?> classType) {
        return this.setResultAction(null, null, null, mapping, null, null, false, classType);
    }

    public ResultActionBuilder setResultActionMapping(String name, String mapping, Class<?> classType) {
        return this.setResultAction(name, null, null, mapping, null, null, false, classType);
    }

    public ResultActionBuilder setResultActionMapping(String name, String mapping, ScopeType scope, Class<?> classType) {
        return this.setResultAction(name, null, null, mapping, null, null, false, classType);
    }

    public BeanBuilder buildParameter(Class<?> classType) {
        String beanName = this.action.getCode() + "#" + this.action.getParamterSize();
        BeanBuilder bb = this.controllerBuilder.buildMappingBean(beanName, null, classType);
        this.setResultActionMapping(beanName, classType);
        return bb;
    }

    public BeanBuilder buildParameter(String name, Class<?> classType) {
        String beanName = this.action.getCode() + "#" + this.action.getParamterSize();
        BeanBuilder bb = this.controllerBuilder.buildMappingBean(beanName, null, classType);
        this.setResultActionMapping(name, beanName, classType);
        return bb;
    }

    public BeanBuilder buildResultAction(Class<?> classType, Class<?> beanType) {
        String beanName = this.action.getCode() + "#Result";
        BeanBuilder bb = this.controllerBuilder.buildMappingBean(beanName, null, beanType);
        this.setResultActionMapping(beanName, classType);
        return bb;
    }

    public BeanBuilder buildResultAction(String name, Class<?> classType, Class<?> beanType) {
        String beanName = this.action.getCode() + "#Result";
        BeanBuilder bb = this.controllerBuilder.buildMappingBean(beanName, null, beanType);
        this.setResultAction(name, beanName, classType);
        return bb;
    }

    public ResultActionBuilder setStaticResultAction(Class<?> classType, Object value) {
        return this.setResultAction(null, null, null, null, null, value, false, classType);
    }

    public ResultActionBuilder setResultAction(String name, EnumerationType enumProperty, String temporalProperty, String mapping, Type typeDef, Object value, boolean nullable, Class<?> classType) {
        return this.setResultAction(name, enumProperty, temporalProperty, mapping, typeDef, value, nullable, (Object)classType);
    }

    public ResultActionBuilder setGenericResultAction(String name, Class<?> classType) {
        return this.setResultAction(name, null, null, null, null, null, false, true, classType);
    }

    public ResultActionBuilder setGenericResultAction(String name) {
        return this.setResultAction(name, null, null, null, null, null, false, true, null);
    }

    public ResultActionBuilder setResultAction(String name, EnumerationType enumProperty, String temporalProperty, String mapping, Type typeDef, Object value, boolean nullable, Object classType) {
        return this.setResultAction(name, enumProperty, temporalProperty, mapping, typeDef, value, nullable, false, classType);
    }

    public ResultActionBuilder setResultAction(String name, EnumerationType enumProperty, String temporalProperty, String mapping, Type typeDef, Object value, boolean nullable, boolean generic, Object classType) {
        name = StringUtil.adjust(name);
        temporalProperty = StringUtil.adjust(temporalProperty);
        mapping = StringUtil.adjust(mapping);
        Class rawType = TypeUtil.getRawType(classType);
        name = name == null ? "result" : name;
        temporalProperty = StringUtil.isEmpty(temporalProperty) ? this.applicationContext.getTemporalProperty() : StringUtil.adjust(temporalProperty);
        enumProperty = enumProperty == null ? this.applicationContext.getEnumerationType() : enumProperty;
        Configuration validatorConfig = new Configuration();
        ResultAction resultAction = new ResultAction(this.action);
        resultAction.setName(name);
        resultAction.setScopeType(ScopeType.PARAM);
        resultAction.setValidate(this.validatorFactory.getValidator(validatorConfig));
        resultAction.setStaticValue(value);
        resultAction.setNullable(nullable);
        if (typeDef == null) {
            if (classType != null) {
                try {
                    typeDef = this.applicationContext.getTypeManager().getType(classType, enumProperty, temporalProperty);
                }
                catch (UnknownTypeException e) {
                    throw new MappingException(String.format("<invalid> %s.%s(...): %s", this.controller.getClassType().getName(), this.action.getExecutor(), e.getMessage()), e);
                }
            }
            if (typeDef == null) {
                typeDef = new ObjectType(rawType);
            }
        } else if (classType != null && !typeDef.getClassType().isAssignableFrom(rawType)) {
            throw new MappingException(String.format("expected %s found %s", rawType.getName(), typeDef.getClassType().getName()));
        }
        resultAction.setType(typeDef);
        if (generic) {
            MetaBean metaBean = new MetaBean(this.controller);
            metaBean.setClassType(rawType);
            resultAction.setMetaBean(metaBean);
        } else if (!StringUtil.isEmpty(mapping)) {
            if (this.controller.getBean(mapping) != null) {
                resultAction.setMapping(this.controller.getBean(mapping));
            } else {
                throw new MappingException("mapping not found: " + mapping);
            }
        }
        this.action.setResultAction(resultAction);
        return new ResultActionBuilder(this, resultAction, this.validatorFactory);
    }

    public ResultActionBuilder getResultAction() {
        return new ResultActionBuilder(this, this.action.getResultAction(), this.validatorFactory);
    }
}

