/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.mapping.ActionID;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.ControllerID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionType {
    private static final Map<String, ActionType> defaultTypes = new HashMap<String, ActionType>();
    public static final ActionType PARAMETER = new ActionType(){

        @Override
        public String id() {
            return "PARAMETER";
        }

        @Override
        public String name() {
            return "Parameter";
        }

        @Override
        public String getControllerID(String className) {
            return className;
        }

        @Override
        public String getActionID(String actionName) {
            return actionName;
        }

        @Override
        public boolean isValidControllerId(String value) {
            return value != null;
        }

        @Override
        public boolean isValidActionId(String value) {
            return value != null;
        }

        @Override
        public List<ActionID> getIDs(ControllerID controllerID, Controller controller, ActionID actionID, Action action) {
            if (action != null) {
                return null;
            }
            return Arrays.asList(new ActionID(controllerID.getName()));
        }
    };

    public static ActionType valueOf(String value) {
        if (value == null) {
            return null;
        }
        return defaultTypes.get(value.toUpperCase());
    }

    public String id() {
        throw new UnsupportedOperationException();
    }

    public String name() {
        throw new UnsupportedOperationException();
    }

    public String getControllerID(String className) {
        throw new UnsupportedOperationException();
    }

    public boolean isValidControllerId(String value) {
        throw new UnsupportedOperationException();
    }

    public String getActionID(String actionName) {
        throw new UnsupportedOperationException();
    }

    public boolean isValidActionId(String value) {
        throw new UnsupportedOperationException();
    }

    public List<ActionID> getIDs(ControllerID controllerID, Controller controller, ActionID actionID, Action action) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.id();
    }
}

