/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import org.brandao.brutos.ApplicationContext;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.Configuration;
import org.brandao.brutos.ConstructorArgBuilder;
import org.brandao.brutos.ConstructorBuilder;
import org.brandao.brutos.ControllerBuilder;
import org.brandao.brutos.ElementBuilder;
import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.FetchType;
import org.brandao.brutos.KeyBuilder;
import org.brandao.brutos.PropertyBuilder;
import org.brandao.brutos.RestrictionBuilder;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.ValidatorFactory;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.mapping.Bean;
import org.brandao.brutos.mapping.CollectionBean;
import org.brandao.brutos.mapping.ConstructorArgBean;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.DependencyBean;
import org.brandao.brutos.mapping.Element;
import org.brandao.brutos.mapping.Key;
import org.brandao.brutos.mapping.MapBean;
import org.brandao.brutos.mapping.MappingBeanUtil;
import org.brandao.brutos.mapping.MappingException;
import org.brandao.brutos.mapping.PropertyBean;
import org.brandao.brutos.mapping.StringUtil;
import org.brandao.brutos.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanBuilder {
    private Controller controller;
    private ControllerBuilder controllerBuilder;
    private Bean mappingBean;
    private ValidatorFactory validatorFactory;
    private ApplicationContext applicationContext;
    private ConstructorBuilder constructorBuilder;

    public BeanBuilder(Bean mappingBean, Controller controller, ControllerBuilder controllerBuilder, ValidatorFactory validatorFactory, ApplicationContext applicationContext) {
        this.controllerBuilder = controllerBuilder;
        this.mappingBean = mappingBean;
        this.controller = controller;
        this.validatorFactory = validatorFactory;
        this.applicationContext = applicationContext;
    }

    public BeanBuilder setFactory(String factory) {
        this.getLogger().info(String.format("%s defined factory %s", this.getPrefixLogger(), factory));
        this.mappingBean.setFactory(factory);
        return this;
    }

    public BeanBuilder setMethodfactory(String methodFactory) {
        this.getLogger().info(String.format("%s defined method factory %s", this.getPrefixLogger(), methodFactory));
        this.mappingBean.setMethodfactory(methodFactory);
        return this;
    }

    public BeanBuilder setSeparator(String separator) {
        this.getLogger().info(String.format("%s separator defined to %s", this.getPrefixLogger(), separator));
        this.mappingBean.setSeparator(separator);
        return this;
    }

    public PropertyBuilder addProperty(String name, String propertyName, EnumerationType enumProperty) {
        return this.addProperty(name, propertyName, enumProperty, null, null, null, null, false, null);
    }

    public PropertyBuilder addNullProperty(String propertyName) {
        return this.addProperty(null, propertyName, null, null, null, null, null, true, null);
    }

    public PropertyBuilder addProperty(String name, String propertyName, String temporalProperty) {
        return this.addProperty(name, propertyName, null, temporalProperty, null, null, null, false, null);
    }

    public PropertyBuilder addProperty(String name, String propertyName, Type type) {
        return this.addProperty(name, propertyName, null, null, null, null, null, false, type);
    }

    public PropertyBuilder addMappedProperty(String name, String propertyName, String mapping) {
        return this.addProperty(name, propertyName, null, null, mapping, null, null, false, null);
    }

    public PropertyBuilder addMappedProperty(String name, String propertyName, String mapping, FetchType fetchType) {
        return this.addProperty(name, propertyName, null, null, mapping, null, null, false, false, null, fetchType, null);
    }

    public PropertyBuilder addMappedProperty(String propertyName, String mapping) {
        return this.addProperty(null, propertyName, null, null, mapping, null, null, false, null);
    }

    public KeyBuilder setMappedKey(String name, String ref) {
        return this.setKey(name, null, null, ref, null, null, null, null);
    }

    public KeyBuilder setKey(String ref) {
        return this.setMappedKey(ref);
    }

    public KeyBuilder setMappedKey(String ref) {
        return this.setMappedKey(null, ref);
    }

    public KeyBuilder setKey(String name, EnumerationType enumProperty, Class<?> classType) {
        return this.setKey(name, enumProperty, null, null, null, null, null, classType);
    }

    public KeyBuilder setKey(String name, String temporalProperty, Class<?> classType) {
        return this.setKey(name, null, temporalProperty, null, null, null, null, classType);
    }

    public KeyBuilder setKey(String name, EnumerationType enumProperty, ScopeType scope, Class<?> classType) {
        return this.setKey(name, enumProperty, null, null, scope, null, null, classType);
    }

    public KeyBuilder setKey(String name, String temporalProperty, ScopeType scope, Class<?> classType) {
        return this.setKey(name, null, temporalProperty, null, scope, null, null, classType);
    }

    public KeyBuilder setKey(String name, ScopeType scope, Class<?> classType) {
        return this.setKey(name, null, null, null, scope, null, null, classType);
    }

    public KeyBuilder setKey(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, Type typeDef, Class<?> type) {
        return this.setKey(name, enumProperty, temporalProperty, mapping, scope, value, typeDef, (Object)type);
    }

    public KeyBuilder setGenericKey(String name, Class<?> classType) {
        return this.setKey(name, null, null, null, null, null, true, null, classType);
    }

    public KeyBuilder setKey(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, Type typeDef, Object type) {
        return this.setKey(name, enumProperty, temporalProperty, mapping, scope, value, false, typeDef, type);
    }

    public KeyBuilder setKey(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean generic, Type typeDef, Object type) {
        if (!this.mappingBean.isMap()) {
            throw new BrutosException(String.format("is not allowed for this type: %s", this.mappingBean.getClassType()));
        }
        name = StringUtil.adjust(name);
        enumProperty = enumProperty == null ? this.applicationContext.getEnumerationType() : enumProperty;
        temporalProperty = StringUtil.isEmpty(temporalProperty) ? this.applicationContext.getTemporalProperty() : temporalProperty;
        ScopeType scopeType = scope = scope == null ? this.applicationContext.getScopeType() : scope;
        if (type == null && mapping == null) {
            throw new MappingException("unknown key type");
        }
        if (type == null && mapping == null) {
            throw new MappingException("unknown key type");
        }
        Element e = (Element)((MapBean)this.mappingBean).getCollection();
        if (e != null) {
            if (e.getParameterName() != null && name == null) {
                name = "key";
            } else if (e.getParameterName() == null && name != null) {
                e.setParameterName("element");
            }
        }
        if (name == null && (mapping != null || generic)) {
            throw new MappingException("key must have a name");
        }
        DependencyBean key = MappingBeanUtil.createKeyBean(name, enumProperty, temporalProperty, mapping, scope, value, false, generic, typeDef, type, this.mappingBean, FetchType.EAGER, this.validatorFactory, this.controller);
        ((MapBean)this.mappingBean).setKey(key);
        return new KeyBuilder(key, this, this.validatorFactory);
    }

    public BeanBuilder buildKey(Class<?> type) {
        return this.buildKey(null, type);
    }

    public BeanBuilder setMaxItens(int value) {
        if (value < 2) {
            throw new MappingException(value + " < 2");
        }
        if (this.mappingBean.isCollection() || this.mappingBean.isMap()) {
            ((CollectionBean)this.mappingBean).setMaxItens(value);
            return this;
        }
        throw new MappingException("bean type is not a collection");
    }

    public BeanBuilder buildKey(String name, Class<?> type) {
        if (!this.mappingBean.isMap()) {
            throw new BrutosException(String.format("is not allowed for this type: %s", this.mappingBean.getClassType()));
        }
        String beanName = this.mappingBean.getName() + "#key";
        BeanBuilder bb = this.controllerBuilder.buildMappingBean(beanName, this.mappingBean.getName(), type);
        name = StringUtil.adjust(name);
        this.setMappedKey(name, beanName);
        return bb;
    }

    public BeanBuilder buildElement(Class<?> type) {
        return this.buildElement(null, type);
    }

    public BeanBuilder buildElement(String name, Class<?> type) {
        if (!this.mappingBean.isMap() && !this.mappingBean.isCollection()) {
            throw new BrutosException(String.format("is not allowed for this type: %s", this.mappingBean.getClassType()));
        }
        String beanName = this.mappingBean.getName() + "#bean";
        BeanBuilder bb = this.controllerBuilder.buildMappingBean(beanName, this.mappingBean.getName(), type);
        name = StringUtil.adjust(name);
        this.setMappedElement(name, beanName);
        return bb;
    }

    public ElementBuilder setMappedElement(String ref) {
        return this.setMappedElement(null, ref);
    }

    public ElementBuilder setMappedElement(String name, String ref) {
        return this.setElement(name, null, null, ref, null, null, false, null, null);
    }

    public ElementBuilder setMappedElement(String name, String ref, Class<?> classType) {
        return this.setElement(name, null, null, ref, null, null, false, null, classType);
    }

    public ElementBuilder setElement(String name, EnumerationType enumProperty, Class<?> classType) {
        return this.setElement(name, enumProperty, null, null, null, null, false, null, classType);
    }

    public ElementBuilder setElement(String name, String temporalProperty, Class<?> classType) {
        return this.setElement(name, null, temporalProperty, null, null, null, false, null, classType);
    }

    public ElementBuilder setElement(String name, EnumerationType enumProperty, ScopeType scope, Class<?> classType) {
        return this.setElement(name, enumProperty, null, null, scope, null, false, null, classType);
    }

    public ElementBuilder setElement(String name, String temporalProperty, ScopeType scope, Class<?> classType) {
        return this.setElement(name, null, temporalProperty, null, scope, null, false, null, classType);
    }

    public ElementBuilder setElement(String name, ScopeType scope, Class<?> classType) {
        return this.setElement(name, null, null, null, scope, null, false, null, classType);
    }

    public ElementBuilder setElement(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, Type typeDef, Class<?> type) {
        return this.setElement(name, enumProperty, temporalProperty, mapping, scope, value, nullable, typeDef, (Object)type);
    }

    public ElementBuilder setGenericElement(String name, Class<?> classType) {
        return this.setElement(name, null, null, null, null, null, false, true, null, classType);
    }

    public ElementBuilder setElement(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, Type typeDef, Object type) {
        return this.setElement(name, enumProperty, temporalProperty, mapping, scope, value, nullable, false, typeDef, type);
    }

    public ElementBuilder setElement(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, boolean generic, Type typeDef, Object type) {
        Key key;
        if (!this.mappingBean.isCollection() && !this.mappingBean.isMap()) {
            throw new MappingException(String.format("is not allowed for this type: %s", this.mappingBean.getClassType()));
        }
        name = StringUtil.adjust(name);
        enumProperty = enumProperty == null ? this.applicationContext.getEnumerationType() : enumProperty;
        temporalProperty = StringUtil.isEmpty(temporalProperty) ? this.applicationContext.getTemporalProperty() : temporalProperty;
        ScopeType scopeType = scope = scope == null ? this.applicationContext.getScopeType() : scope;
        if (type == null && mapping == null) {
            throw new MappingException("unknown element type");
        }
        if (this.mappingBean.isMap() && (key = (Key)((MapBean)this.mappingBean).getKey()) != null) {
            if (key.getParameterName() != null && name == null) {
                name = "element";
            } else if (key.getParameterName() == null && name != null) {
                key.setParameterName("key");
            }
        }
        DependencyBean collection = MappingBeanUtil.createElementBean(name, enumProperty, temporalProperty, mapping, scope, value, nullable, generic, typeDef, type, this.mappingBean, FetchType.EAGER, this.validatorFactory, this.controller);
        ((CollectionBean)this.mappingBean).setCollection(collection);
        return new ElementBuilder(collection, this, this.validatorFactory);
    }

    public BeanBuilder setIndexFormat(String indexFormat) {
        if ((indexFormat = StringUtil.adjust(indexFormat)) == null) {
            throw new IllegalArgumentException();
        }
        if (indexFormat.indexOf("$index") == -1) {
            throw new IllegalArgumentException("$index not found");
        }
        this.mappingBean.setIndexFormat(indexFormat);
        return this;
    }

    public RestrictionBuilder setElement(String ref) {
        return this.setMappedElement(null, ref);
    }

    public BeanBuilder buildProperty(String propertyName, Class<?> target) {
        return this.buildProperty(null, propertyName, target);
    }

    public BeanBuilder buildProperty(String name, String propertyName, Class<?> target) {
        name = StringUtil.adjust(name);
        String beanName = this.mappingBean.getName() + "#" + propertyName;
        BeanBuilder beanBuilder = this.controllerBuilder.buildMappingBean(beanName, this.mappingBean.getName(), target);
        this.addMappedProperty(name, propertyName, beanName);
        return beanBuilder;
    }

    public PropertyBuilder addProperty(String name, String propertyName) {
        return this.addProperty(name, propertyName, null, null, null, null, null, false, null);
    }

    public PropertyBuilder addProperty(String name, String propertyName, ScopeType scope) {
        return this.addProperty(name, propertyName, null, null, null, scope, null, false, null);
    }

    public PropertyBuilder addStaticProperty(String name, String propertyName, Object value) {
        return this.addProperty(null, propertyName, null, null, null, null, value, false, null);
    }

    public PropertyBuilder addProperty(String name, String propertyName, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, Type type) {
        return this.addProperty(name, propertyName, enumProperty, temporalProperty, mapping, scope, value, nullable, null, type);
    }

    public PropertyBuilder addGenericProperty(String name, String propertyName, Class<?> classType) {
        return this.addProperty(name, propertyName, null, null, null, null, null, false, true, classType, null);
    }

    public PropertyBuilder addGenericProperty(String name, String propertyName, Class<?> classType, FetchType fetchType) {
        return this.addProperty(propertyName, propertyName, null, null, null, null, null, false, true, classType, fetchType, null);
    }

    public PropertyBuilder addGenericProperty(String name, String propertyName) {
        return this.addProperty(name, propertyName, null, null, null, null, null, false, true, null, null);
    }

    public PropertyBuilder addProperty(String name, String propertyName, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, Object classType, Type type) {
        return this.addProperty(name, propertyName, enumProperty, temporalProperty, mapping, scope, value, nullable, false, classType, type);
    }

    public PropertyBuilder addProperty(String name, String propertyName, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, boolean generic, Object classType, Type type) {
        return this.addProperty(name, propertyName, enumProperty, temporalProperty, mapping, scope, value, nullable, generic, classType, null, type);
    }

    public PropertyBuilder addProperty(String name, String propertyName, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, boolean generic, Object classType, FetchType fetchType, Type type) {
        name = StringUtil.isEmpty(name = StringUtil.adjust(name)) ? propertyName : name;
        enumProperty = enumProperty == null ? this.applicationContext.getEnumerationType() : enumProperty;
        temporalProperty = StringUtil.isEmpty(temporalProperty) ? this.applicationContext.getTemporalProperty() : temporalProperty;
        scope = scope == null ? this.applicationContext.getScopeType() : scope;
        fetchType = fetchType == null ? this.applicationContext.getFetchType() : fetchType;
        PropertyBean propertyBean = (PropertyBean)MappingBeanUtil.createProperty(name, propertyName, enumProperty, temporalProperty, mapping, scope, value, nullable, generic, type, classType, this.mappingBean, fetchType, this.validatorFactory, this.controller);
        this.getLogger().info(String.format("%s added property %s", this.getPrefixLogger(), propertyName));
        Configuration validatorConfig = new Configuration();
        propertyBean.setValidator(this.validatorFactory.getValidator(validatorConfig));
        propertyBean.setBeanProperty(this.mappingBean.getBeanInstance().getProperty(propertyName));
        propertyBean.setRealName(propertyName);
        this.mappingBean.getFields().put(propertyName, propertyBean);
        return new PropertyBuilder(propertyBean, this, this.validatorFactory);
    }

    public ConstructorBuilder buildConstructor() {
        this.constructorBuilder = new ConstructorBuilder(this.mappingBean, this, this.validatorFactory, this.controller);
        return this.constructorBuilder;
    }

    public ControllerBuilder getControllerBuilder() {
        return this.controllerBuilder;
    }

    public PropertyBuilder getProperty(String name) {
        PropertyBean property = this.mappingBean.getFields().get(name);
        return property == null ? null : new PropertyBuilder(property, this, this.validatorFactory);
    }

    public ConstructorArgBuilder getConstructorArg(int index) {
        ConstructorArgBean arg = this.mappingBean.getConstructor().getConstructorArg(index);
        return new ConstructorArgBuilder(arg, this.constructorBuilder, this.validatorFactory);
    }

    public String getName() {
        return this.mappingBean.getName();
    }

    public int getConstructorArgSize() {
        return this.mappingBean.getConstructor().size();
    }

    public Class<?> getClassType() {
        return this.mappingBean.getClassType();
    }

    public boolean isMap() {
        return this.mappingBean.isMap();
    }

    public boolean isCollection() {
        return this.mappingBean.isCollection();
    }

    protected String getPrefixLogger() {
        return this.mappingBean.getName() + ":";
    }

    protected Logger getLogger() {
        return LoggerProvider.getCurrentLoggerProvider().getLogger(ControllerBuilder.class);
    }
}

