/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.brandao.brutos.type.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private static final Map<Object, Type> primitiveType = new HashMap<Object, Type>();

    public static Class<?> getWrapper(Class<?> clazz) {
        Class classe = (Class)primitiveType.get(clazz);
        return classe == null ? clazz : classe;
    }

    public static Class<?> get(String name) throws ClassNotFoundException {
        Class<?> classe = (Class<?>)primitiveType.get(name);
        return classe == null ? ClassUtil.getClasse(name) : classe;
    }

    private static Class<?> getClasse(String name) throws ClassNotFoundException {
        return ClassUtil.getClasse(name, true);
    }

    private static Class<?> getClasse(String name, boolean initialize) throws ClassNotFoundException {
        return Class.forName(name, initialize, Thread.currentThread().getContextClassLoader());
    }

    public static Object getInstance(Class<?> clazz, Class<?>[] params, Object[] values) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?> cons = clazz.getConstructor(params);
        return cons.newInstance(values);
    }

    public static <T> T getInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public static Object getInstance(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return ClassUtil.getClasse(name).newInstance();
    }

    public static List<?> getListInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (List)ClassUtil.getInstance(TypeUtil.getDefaultListType());
    }

    public static ConcurrentMap<?, ?> getConcurrentMapInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (ConcurrentMap)ClassUtil.getInstance(TypeUtil.getDefaultConcurrentMapType());
    }

    public static Map<?, ?> getMapInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (Map)ClassUtil.getInstance(TypeUtil.getDefaultMapType());
    }

    public static Set<?> getSetInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (Set)ClassUtil.getInstance(TypeUtil.getDefaultSetType());
    }

    public static Class<?> getInstantiableClass(Class<?> clazz) {
        if (clazz == ConcurrentMap.class) {
            return TypeUtil.getDefaultConcurrentMapType();
        }
        if (clazz == Map.class) {
            return TypeUtil.getDefaultMapType();
        }
        if (clazz == List.class) {
            return TypeUtil.getDefaultListType();
        }
        if (clazz == Set.class) {
            return TypeUtil.getDefaultSetType();
        }
        return clazz;
    }

    public static boolean existClass(String className) {
        try {
            Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        primitiveType.put("boolean", Boolean.TYPE);
        primitiveType.put("byte", Byte.TYPE);
        primitiveType.put("char", Character.TYPE);
        primitiveType.put("double", Double.TYPE);
        primitiveType.put("float", Float.TYPE);
        primitiveType.put("int", Integer.TYPE);
        primitiveType.put("long", Long.TYPE);
        primitiveType.put("short", Short.TYPE);
        primitiveType.put("void", Void.TYPE);
        primitiveType.put(Boolean.TYPE, (Type)((Object)Boolean.class));
        primitiveType.put(Byte.TYPE, (Type)((Object)Byte.class));
        primitiveType.put(Character.TYPE, (Type)((Object)Character.class));
        primitiveType.put(Double.TYPE, (Type)((Object)Double.class));
        primitiveType.put(Float.TYPE, (Type)((Object)Float.class));
        primitiveType.put(Integer.TYPE, (Type)((Object)Integer.class));
        primitiveType.put(Long.TYPE, (Type)((Object)Long.class));
        primitiveType.put(Short.TYPE, (Type)((Object)Short.class));
        primitiveType.put(Void.TYPE, (Type)((Object)Void.class));
    }
}

