/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import org.brandao.brutos.BeanBuilder;
import org.brandao.brutos.Configuration;
import org.brandao.brutos.ConstructorArgBuilder;
import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.FetchType;
import org.brandao.brutos.RestrictionBuilder;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.ValidatorFactory;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.mapping.Bean;
import org.brandao.brutos.mapping.ConstructorArgBean;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.MappingBeanUtil;
import org.brandao.brutos.mapping.MappingException;
import org.brandao.brutos.mapping.StringUtil;
import org.brandao.brutos.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorBuilder
extends RestrictionBuilder {
    private Bean mappingBean;
    private BeanBuilder beanBuilder;
    private ValidatorFactory validatorFactory;
    private Controller controller;

    public ConstructorBuilder(Bean mappingBean, BeanBuilder beanBuilder, ValidatorFactory validatorFactory, Controller controller) {
        super(mappingBean.getConstructor().getValidator().getConfiguration());
        this.mappingBean = mappingBean;
        this.beanBuilder = beanBuilder;
        this.validatorFactory = validatorFactory;
        this.controller = controller;
    }

    public BeanBuilder buildConstructorArg(String name, Class<?> target) {
        name = StringUtil.adjust(name);
        String beanName = this.mappingBean.getName() + "#" + this.mappingBean.getConstructor().size();
        BeanBuilder beanBuilder = this.beanBuilder.getControllerBuilder().buildMappingBean(beanName, this.mappingBean.getName(), target);
        this.addMappedContructorArg(name, beanName);
        return beanBuilder;
    }

    public BeanBuilder buildConstructorArg(String name, Class<?> classType, Class<?> target) {
        name = StringUtil.adjust(name);
        String beanName = this.mappingBean.getName() + "#" + this.mappingBean.getConstructor().size();
        BeanBuilder beanBuilder = this.beanBuilder.getControllerBuilder().buildMappingBean(beanName, this.mappingBean.getName(), target);
        this.addMappedContructorArg(name, beanName);
        return beanBuilder;
    }

    public ConstructorArgBuilder addContructorArg(String name, EnumerationType enumProperty) {
        return this.addContructorArg(name, enumProperty, null, null, null, null, false, null, null);
    }

    public ConstructorArgBuilder addContructorArg(String name, String temporalProperty) {
        return this.addContructorArg(name, null, temporalProperty, null, null, null, false, null, null);
    }

    public ConstructorArgBuilder addNullContructorArg() {
        return this.addContructorArg(null, null, null, null, null, null, true, null, null);
    }

    public ConstructorArgBuilder addContructorArg(String name, Type type) {
        return this.addContructorArg(name, null, null, null, null, null, false, type, null);
    }

    public ConstructorArgBuilder addMappedContructorArg(String name, String mapping) {
        return this.addContructorArg(name, null, null, mapping, null, null, false, null, null);
    }

    public ConstructorArgBuilder addMappedContructorArg(String name, String mapping, Class<?> type) {
        return this.addContructorArg(name, null, null, mapping, null, null, false, false, null, type);
    }

    public ConstructorArgBuilder addMappedContructorArg(String name, String mapping, Class<?> type, FetchType fetchType) {
        return this.addContructorArg(name, null, null, mapping, null, null, false, false, null, fetchType, null);
    }

    public ConstructorArgBuilder addContructorArg(String name) {
        return this.addContructorArg(name, null, null, null, null, null, false, null, null);
    }

    public ConstructorArgBuilder addContructorArg(String name, ScopeType scope) {
        return this.addContructorArg(name, null, null, null, scope, null, false, null, null);
    }

    public ConstructorArgBuilder addStaticContructorArg(String name, Object value) {
        return this.addContructorArg(name, null, null, null, null, value, false, null, null);
    }

    public ConstructorArgBuilder addContructorArg(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, Type typeDef, Class<?> type) {
        return this.addContructorArg(name, enumProperty, temporalProperty, mapping, scope, value, nullable, false, typeDef, type);
    }

    public ConstructorArgBuilder addGenericContructorArg(String name, Class<?> type) {
        return this.addContructorArg(name, null, null, null, null, null, false, true, null, type);
    }

    public ConstructorArgBuilder addGenericContructorArg(String name, Class<?> type, FetchType fetchType) {
        return this.addContructorArg(name, null, null, null, null, null, false, true, null, fetchType, null);
    }

    public ConstructorArgBuilder addGenericContructorArg(String name) {
        return this.addContructorArg(name, null, null, null, null, null, false, true, null, null);
    }

    public ConstructorArgBuilder addContructorArg(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, boolean generic, Type typeDef, Object type) {
        return this.addContructorArg(name, enumProperty, temporalProperty, mapping, scope, value, nullable, generic, typeDef, null, type);
    }

    public ConstructorArgBuilder addContructorArg(String name, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Object value, boolean nullable, boolean generic, Type typeDef, FetchType fetchType, Object type) {
        name = StringUtil.adjust(name);
        enumProperty = enumProperty == null ? this.controller.getContext().getEnumerationType() : enumProperty;
        temporalProperty = StringUtil.isEmpty(temporalProperty) ? this.controller.getContext().getTemporalProperty() : temporalProperty;
        scope = scope == null ? this.controller.getContext().getScopeType() : scope;
        FetchType fetchType2 = fetchType = fetchType == null ? this.controller.getContext().getFetchType() : fetchType;
        if (StringUtil.isEmpty(name) && StringUtil.isEmpty(mapping) && !generic && value == null && !nullable) {
            throw new IllegalArgumentException("bean name is required");
        }
        if (scope == null) {
            throw new MappingException("invalid scope");
        }
        ConstructorArgBean arg = (ConstructorArgBean)MappingBeanUtil.createConstructorArg(name, enumProperty, temporalProperty, mapping, scope, value, nullable, generic, typeDef, type, this.mappingBean, fetchType, this.validatorFactory, this.controller);
        if (type == null) {
            arg.setType(null);
        }
        this.getLogger().info(String.format("%s added constructor arg %s", this.getPrefixLogger(), String.valueOf(this.mappingBean.getConstructor().size())));
        Configuration validatorConfig = new Configuration();
        arg.setValidator(this.validatorFactory.getValidator(validatorConfig));
        this.mappingBean.getConstructor().addConstructorArg(arg);
        return new ConstructorArgBuilder(arg, this, this.validatorFactory);
    }

    protected String getPrefixLogger() {
        return this.mappingBean.getName() + ":";
    }

    protected Logger getLogger() {
        return LoggerProvider.getCurrentLoggerProvider().getLogger(ConstructorBuilder.class);
    }

    public int getConstructorArgSize() {
        return this.mappingBean.getConstructor().size();
    }

    public ConstructorArgBuilder getConstructorArg(int index) {
        ConstructorArgBean arg = this.mappingBean.getConstructor().getConstructorArg(index);
        return new ConstructorArgBuilder(arg, this, this.validatorFactory);
    }

    public Class<?> getClassType() {
        return this.mappingBean.getClassType();
    }

    public BeanBuilder getBeanBuilder() {
        return this.beanBuilder;
    }
}

