/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.brandao.brutos.ActionBuilder;
import org.brandao.brutos.ActionType;
import org.brandao.brutos.BeanBuilder;
import org.brandao.brutos.ConfigurableApplicationContext;
import org.brandao.brutos.Configuration;
import org.brandao.brutos.ControllerManager;
import org.brandao.brutos.DataType;
import org.brandao.brutos.DispatcherType;
import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.FetchType;
import org.brandao.brutos.InterceptorBuilder;
import org.brandao.brutos.InterceptorManager;
import org.brandao.brutos.PropertyBuilder;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.ValidatorFactory;
import org.brandao.brutos.bean.BeanInstance;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.mapping.ActionID;
import org.brandao.brutos.mapping.Bean;
import org.brandao.brutos.mapping.CollectionBean;
import org.brandao.brutos.mapping.ConstructorBean;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.ControllerID;
import org.brandao.brutos.mapping.Interceptor;
import org.brandao.brutos.mapping.InterceptorStack;
import org.brandao.brutos.mapping.MapBean;
import org.brandao.brutos.mapping.MappingException;
import org.brandao.brutos.mapping.MetaBean;
import org.brandao.brutos.mapping.PropertyController;
import org.brandao.brutos.mapping.StringUtil;
import org.brandao.brutos.mapping.ThrowableSafeData;
import org.brandao.brutos.type.NullType;
import org.brandao.brutos.type.ObjectType;
import org.brandao.brutos.type.Type;
import org.brandao.brutos.type.TypeUtil;
import org.brandao.brutos.type.UnknownTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerBuilder {
    protected final Controller controller;
    protected ControllerManager controllerManager;
    protected InterceptorManager interceptorManager;
    protected ValidatorFactory validatorFactory;
    protected ConfigurableApplicationContext applicationContext;
    protected ControllerManager.InternalUpdate internalUpdate;

    public ControllerBuilder(ControllerBuilder builder, ControllerManager.InternalUpdate internalUpdate) {
        this(builder.controller, builder.controllerManager, builder.interceptorManager, builder.validatorFactory, builder.applicationContext, internalUpdate);
    }

    public ControllerBuilder(Controller controller, ControllerManager controllerManager, InterceptorManager interceptorManager, ValidatorFactory validatorFactory, ConfigurableApplicationContext applicationContext, ControllerManager.InternalUpdate internalUpdate) {
        this.controller = controller;
        this.controllerManager = controllerManager;
        this.interceptorManager = interceptorManager;
        this.validatorFactory = validatorFactory;
        this.applicationContext = applicationContext;
        this.internalUpdate = internalUpdate;
    }

    public ControllerBuilder addAlias(String id) {
        id = StringUtil.adjust(id);
        if (!this.controller.getActionType().isValidControllerId(id)) {
            throw new MappingException("invalid controller alias: " + id);
        }
        if (StringUtil.isEmpty(id)) {
            throw new MappingException("invalid alias");
        }
        ControllerID controllerID = new ControllerID(id);
        return this.addAlias(controllerID);
    }

    protected ControllerBuilder addAlias(ControllerID id) {
        this.internalUpdate.addControllerAlias(this.controller, id);
        this.controller.getAlias().add(id);
        this.getLogger().info(String.format("add alias %s on controller %s", id, this.controller.getClassType().getSimpleName()));
        return this;
    }

    public ControllerBuilder removeAlias(String id) {
        if (StringUtil.isEmpty(id = StringUtil.adjust(id))) {
            throw new MappingException("invalid alias");
        }
        ControllerID controllerID = new ControllerID(id);
        return this.removeAlias(controllerID);
    }

    protected ControllerBuilder removeAlias(ControllerID id) {
        this.internalUpdate.removeControllerAlias(this.controller, id);
        this.controller.getAlias().remove(id);
        this.getLogger().info(String.format("removed alias %s on controller %s", id.getName(), this.controller.getClassType().getSimpleName()));
        return this;
    }

    public ControllerBuilder addThrowable(Class<?> target, String id) {
        return this.addThrowable(target, null, false, id, null);
    }

    public ControllerBuilder addThrowable(Class<?> target, String view, boolean resolvedView, String id, DispatcherType dispatcher) {
        return this.addThrowable(target, view, id, dispatcher, resolvedView);
    }

    public ControllerBuilder addThrowable(Class<?> target, String view, String id, DispatcherType dispatcher, boolean resolvedView) {
        view = StringUtil.adjust(view);
        view = resolvedView ? view : this.applicationContext.getViewResolver().getView(this, null, target, view);
        id = StringUtil.isEmpty(id) ? "exception" : StringUtil.adjust(id);
        DispatcherType dispatcherType = dispatcher = dispatcher == null ? this.applicationContext.getDispatcherType() : dispatcher;
        if (target == null) {
            throw new MappingException("target is required: " + this.controller.getClassType().getSimpleName());
        }
        if (!Throwable.class.isAssignableFrom(target)) {
            throw new MappingException("target is not allowed: " + target.getSimpleName());
        }
        if (this.controller.getThrowsSafe(target) != null) {
            throw new MappingException("the exception has been added on controller: " + target.getSimpleName());
        }
        ThrowableSafeData thr = new ThrowableSafeData();
        thr.setParameterName(id);
        thr.setTarget(target);
        thr.setView(view);
        thr.setRedirect(false);
        thr.setDispatcher(dispatcher);
        this.controller.setThrowsSafe(thr);
        this.getLogger().info(String.format("added exception %s on controller %s", target.getSimpleName(), this.controller.getClassType().getSimpleName()));
        return this;
    }

    public ControllerBuilder setDefaultAction(String id) {
        id = StringUtil.adjust(id);
        ActionID actionID = new ActionID(id);
        if (StringUtil.isEmpty(id)) {
            throw new MappingException("invalid id");
        }
        if (this.controller.getActionById(actionID) == null) {
            throw new MappingException("action not found: \"" + id + "\"");
        }
        this.controller.setDefaultAction(actionID);
        this.getLogger().info(String.format("adding default action %s on controller %s", id, this.controller.getClassType().getSimpleName()));
        return this;
    }

    public BeanBuilder buildMappingBean(String name, Class<?> target) {
        return this.buildMappingBean(name, null, target);
    }

    public BeanBuilder buildMappingBean(String name, String parentBeanName, Class<?> target) {
        Bean parentBean;
        name = StringUtil.adjust(name);
        if (target == null) {
            throw new MappingException("invalid target class");
        }
        if (name == null || !name.matches("[a-zA-Z0-9_#]+")) {
            throw new MappingException("invalid bean name: \"" + name + "\"");
        }
        if (this.controller.getBean(name) != null) {
            throw new MappingException("duplicate bean name: \"" + name + "\"");
        }
        Bean bean = parentBean = parentBeanName == null ? null : this.controller.getBean(parentBeanName);
        Bean mappingBean = Map.class.isAssignableFrom(target) ? new MapBean(this.controller, parentBean) : (Collection.class.isAssignableFrom(target) ? new CollectionBean(this.controller, parentBean) : new Bean(this.controller, parentBean));
        ConstructorBean constructor = mappingBean.getConstructor();
        constructor.setValidator(this.validatorFactory.getValidator(new Configuration()));
        mappingBean.setClassType(target);
        mappingBean.setName(name);
        this.controller.addBean(name, mappingBean);
        BeanBuilder mb = new BeanBuilder(mappingBean, this.controller, this, this.validatorFactory, this.applicationContext);
        this.getLogger().info(String.format("added bean %s[%s]", name, target.getSimpleName()));
        return mb;
    }

    public ActionBuilder addAction(String id) {
        return this.addAction(id, null, null, false, null, null);
    }

    public ActionBuilder addAction(String id, String executor) {
        return this.addAction(id, null, null, false, null, executor);
    }

    public ActionBuilder addAction(String id, String executor, String view, boolean resolvedView) {
        return this.addAction(id, null, view, resolvedView, null, executor);
    }

    public ActionBuilder addAction(String id, String resultId, String view, boolean resolvedView, String executor) {
        return this.addAction(id, resultId, view, resolvedView, null, executor);
    }

    public ActionBuilder addAction(String id, String resultId, String view, boolean resolvedView, DispatcherType dispatcher, String executor) {
        return this.addAction(id, resultId, false, view, resolvedView, dispatcher, executor);
    }

    public ActionBuilder addAction(String id, String resultId, boolean resultRendered, String view, boolean resolvedView, DispatcherType dispatcher, String executor) {
        return this.addAction(id, resultId, resultRendered, view, dispatcher, resolvedView, executor);
    }

    public ActionBuilder addAction(String id, String resultId, boolean resultRendered, String view, DispatcherType dispatcher, boolean resolvedView, String executor) {
        id = StringUtil.adjust(id);
        resultId = StringUtil.adjust(resultId);
        view = StringUtil.adjust(view);
        executor = StringUtil.adjust(executor);
        if (StringUtil.isEmpty(id) && !StringUtil.isEmpty(executor)) {
            id = executor.replaceAll("Action$", "");
        }
        ActionID actionId = new ActionID(id);
        DispatcherType dispatcherType = dispatcher = dispatcher == null ? this.applicationContext.getDispatcherType() : dispatcher;
        if (StringUtil.isEmpty(id)) {
            throw new MappingException("action id cannot be empty");
        }
        if (StringUtil.isEmpty(view) && StringUtil.isEmpty(executor)) {
            throw new MappingException("view must be informed in abstract actions: " + id);
        }
        if (this.controller.getActionById(actionId) != null) {
            throw new MappingException("duplicate action: " + id);
        }
        Action action = new Action();
        action.setId(actionId);
        action.setCode(Action.getNextId());
        action.setName(id);
        action.setController(this.controller);
        action.setResultValidator(this.validatorFactory.getValidator(new Configuration()));
        action.setParametersValidator(this.validatorFactory.getValidator(new Configuration()));
        this.controller.addAction(actionId, action);
        ActionBuilder actionBuilder = new ActionBuilder(action, this.controller, this.validatorFactory, this, this.applicationContext);
        actionBuilder.setDispatcherType(dispatcher).setExecutor(executor).setResult(resultId).setResultRendered(resultRendered).setView(view, resolvedView);
        this.getLogger().info(String.format("adding action %s on controller %s", action.getId(), this.controller.getClassType().getSimpleName()));
        return actionBuilder;
    }

    public InterceptorBuilder addInterceptor(String name) {
        if (StringUtil.isEmpty(name = StringUtil.adjust(name))) {
            throw new MappingException("interceptor name must be informed");
        }
        if (!this.interceptorManager.containsInterceptor(name)) {
            throw new MappingException("interceptor not found: " + name);
        }
        Interceptor parent = this.interceptorManager.getInterceptor(name);
        if (parent.isDefault()) {
            throw new MappingException("interceptor already intercept this controller: " + name);
        }
        if (this.controller.isInterceptedBy(parent)) {
            throw new MappingException("interceptor already intercept this controller: " + name);
        }
        Interceptor it = parent instanceof InterceptorStack ? new InterceptorStack((InterceptorStack)parent) : new Interceptor(parent);
        it.setProperties(new HashMap<String, Object>());
        Set<String> keys = parent.getProperties().keySet();
        for (String key : keys) {
            Object value = parent.getProperties().get(key);
            it.getProperties().put(key, value);
        }
        this.getLogger().info(String.format("adding interceptor %s on controller %s", name, this.controller.getClassType().getSimpleName()));
        this.controller.addInterceptor(it);
        return new InterceptorBuilder(it, this.interceptorManager);
    }

    public PropertyBuilder addProperty(String propertyName, String id, ScopeType scope, EnumerationType enumProperty) {
        return this.addProperty(propertyName, id, scope, enumProperty, null, null, null, false, null);
    }

    public PropertyBuilder addNullProperty(String propertyName) {
        return this.addProperty(propertyName, null, null, null, null, null, null, true, null);
    }

    public PropertyBuilder addProperty(String propertyName, String id, ScopeType scope, String temporalProperty) {
        return this.addProperty(propertyName, id, scope, null, null, null, null, false, null);
    }

    public PropertyBuilder addProperty(String propertyName, String id, ScopeType scope, Type type) {
        return this.addProperty(propertyName, id, scope, null, null, null, null, false, type);
    }

    public PropertyBuilder addProperty(String propertyName, String id, EnumerationType enumProperty) {
        return this.addProperty(propertyName, id, null, enumProperty, null, null, null, false, null);
    }

    public PropertyBuilder addProperty(String propertyName, String id, ScopeType scope) {
        return this.addProperty(propertyName, id, scope, null, null, null, null, false, null);
    }

    public PropertyBuilder addProperty(String propertyName, String id, String temporalProperty) {
        return this.addProperty(propertyName, id, null, null, temporalProperty, null, null, false, null);
    }

    public PropertyBuilder addProperty(String propertyName, String id, Type type) {
        return this.addProperty(propertyName, id, null, null, null, null, null, false, type);
    }

    public PropertyBuilder addPropertyMapping(String propertyName, String mapping) {
        return this.addProperty(propertyName, null, null, null, null, mapping, null, false, null);
    }

    public PropertyBuilder addPropertyMapping(String propertyName, String id, String mapping) {
        return this.addProperty(propertyName, id, null, null, null, mapping, null, false, null);
    }

    public PropertyBuilder addPropertyMapping(String propertyName, String id, String mapping, FetchType fetchType) {
        return this.addProperty(propertyName, id, null, null, null, mapping, null, false, false, null, fetchType, null);
    }

    public PropertyBuilder addProperty(String propertyName, String id) {
        return this.addProperty(propertyName, id, null, null, null, null, null, false, null);
    }

    public PropertyBuilder addStaticProperty(String propertyName, Object value) {
        return this.addProperty(propertyName, null, null, null, null, null, value, false, null);
    }

    public PropertyBuilder addProperty(String propertyName, String id, ScopeType scope, EnumerationType enumProperty, String temporalProperty, String mapping, Object value, boolean nullable, Type type) {
        return this.addProperty(propertyName, id, scope, enumProperty, temporalProperty, mapping, value, nullable, null, type);
    }

    public PropertyBuilder addGenericProperty(String propertyName, String id, Class<?> classType) {
        return this.addProperty(propertyName, id, null, null, null, null, null, false, true, classType, null, null);
    }

    public PropertyBuilder addGenericProperty(String propertyName, String id, Class<?> classType, FetchType fetchType) {
        return this.addProperty(propertyName, id, null, null, null, null, null, false, true, classType, fetchType, null);
    }

    public PropertyBuilder addGenericProperty(String propertyName, String id) {
        return this.addProperty(propertyName, id, null, null, null, null, null, false, true, null, null);
    }

    public PropertyBuilder addProperty(String propertyName, String id, ScopeType scope, EnumerationType enumProperty, String temporalProperty, String mapping, Object value, boolean nullable, Object classType, Type type) {
        return this.addProperty(propertyName, id, scope, enumProperty, temporalProperty, mapping, value, nullable, false, classType, type);
    }

    public PropertyBuilder addProperty(String propertyName, String id, ScopeType scope, EnumerationType enumProperty, String temporalProperty, String mapping, Object value, boolean nullable, boolean generic, Object classType, Type type) {
        return this.addProperty(propertyName, id, scope, enumProperty, temporalProperty, mapping, value, nullable, null, type);
    }

    public PropertyBuilder addProperty(String propertyName, String id, ScopeType scope, EnumerationType enumProperty, String temporalProperty, String mapping, Object value, boolean nullable, boolean generic, Object classType, FetchType fetchType, Type type) {
        propertyName = StringUtil.adjust(propertyName);
        id = StringUtil.isEmpty(id) ? propertyName : StringUtil.adjust(id);
        temporalProperty = StringUtil.isEmpty(temporalProperty) ? this.applicationContext.getTemporalProperty() : StringUtil.adjust(temporalProperty);
        scope = scope == null ? this.applicationContext.getScopeType() : scope;
        enumProperty = enumProperty == null ? this.applicationContext.getEnumerationType() : enumProperty;
        fetchType = fetchType == null ? this.applicationContext.getFetchType() : fetchType;
        mapping = StringUtil.adjust(mapping);
        BeanInstance bean = this.controller.getBeanInstance();
        Object genericType = classType == null ? bean.getGenericType(propertyName) : classType;
        Class rawType = TypeUtil.getRawType(genericType);
        if (propertyName == null) {
            throw new MappingException("property name is required: " + this.controller.getClassType().getName());
        }
        if (this.controller.containsProperty(propertyName)) {
            throw new MappingException("property already added: " + this.controller.getClassType().getName() + "." + propertyName);
        }
        if (scope == null) {
            throw new MappingException("invalid scope");
        }
        PropertyController property = new PropertyController();
        property.setRealName(propertyName);
        property.setName(id);
        property.setFetchType(fetchType);
        property.setScopeType(scope);
        property.setValidate(this.validatorFactory.getValidator(new Configuration()));
        property.setStaticValue(value);
        property.setNullable(nullable);
        property.setPropertyName(propertyName);
        property.setController(this.controller);
        try {
            property.setBeanProperty(bean.getProperty(propertyName));
        }
        catch (Throwable e) {
            throw new MappingException("no such property: " + this.controller.getClassType().getName() + "." + propertyName);
        }
        if (type == null) {
            if (nullable) {
                if (classType == null) {
                    throw new MappingException("type must be informed");
                }
                type = new NullType((Class)classType);
            } else {
                try {
                    type = this.applicationContext.getTypeManager().getType(genericType, enumProperty, temporalProperty);
                }
                catch (UnknownTypeException e) {
                    throw new MappingException(e);
                }
            }
            if (type == null) {
                type = new ObjectType(rawType);
            }
        }
        property.setType(type);
        if (generic) {
            MetaBean metaBean = new MetaBean(this.controller);
            metaBean.setClassType(rawType);
            property.setMetaBean(metaBean);
        } else if (mapping != null) {
            if (this.controller.getBean(mapping) != null) {
                property.setMapping(this.controller.getBean(mapping));
            } else {
                throw new MappingException("mapping not found: " + mapping);
            }
        }
        this.controller.addProperty(property);
        this.getLogger().info(String.format("adding property %s on controller %s", propertyName, this.controller.getClassType().getSimpleName()));
        return new PropertyBuilder(property, this, this.validatorFactory);
    }

    public BeanBuilder buildProperty(String propertyName, Class<?> clazz) {
        String beanName = this.controller.getName() + "Controller#" + propertyName;
        BeanBuilder beanBuilder = this.buildMappingBean(beanName, clazz);
        this.addPropertyMapping(propertyName, beanName);
        return beanBuilder;
    }

    public Class<?> getClassType() {
        return this.controller.getClassType();
    }

    public Bean getBean(String name) {
        return this.controller.getBean(name);
    }

    public String getId() {
        return this.controller.getId().getName();
    }

    public ControllerBuilder setName(String value) {
        if ((value = StringUtil.adjust(value)) == null) {
            value = this.controller.getClassType().getSimpleName();
        }
        this.controller.setName(value);
        return this;
    }

    public String getName() {
        return this.controller.getName();
    }

    public ControllerBuilder setView(String view, boolean resolvedView) {
        view = StringUtil.adjust(view);
        view = resolvedView ? view : this.applicationContext.getViewResolver().getView(this, null, null, view);
        this.controller.setView(view);
        return this;
    }

    public String getView() {
        return this.controller.getView();
    }

    public ControllerBuilder setActionId(String value) {
        if (StringUtil.isEmpty(value) || !value.matches("[a-zA-Z0-9_#]+")) {
            throw new MappingException("invalid action id: " + value);
        }
        this.controller.setActionId(value);
        this.getLogger().info(String.format("override the action id to %s on controller %s", value, this.controller.getClassType().getSimpleName()));
        return this;
    }

    public String getActionId() {
        return this.controller.getActionId();
    }

    public ControllerBuilder setDispatcherType(String value) {
        if (StringUtil.isEmpty(value = StringUtil.adjust(value))) {
            throw new MappingException("invalid dispatcher type");
        }
        this.setDispatcherType(DispatcherType.valueOf(value));
        return this;
    }

    public ControllerBuilder setDispatcherType(DispatcherType value) {
        this.controller.setDispatcherType(value);
        return this;
    }

    public DispatcherType getDispatcherType() {
        return this.controller.getDispatcherType();
    }

    protected Logger getLogger() {
        return LoggerProvider.getCurrentLoggerProvider().getLogger(ControllerBuilder.class);
    }

    public ControllerBuilder setActionType(ActionType actionType) {
        this.controller.setActionType(actionType);
        return this;
    }

    public ActionType getActionType() {
        return this.controller.getActionType();
    }

    public PropertyBuilder getProperty(String name) {
        PropertyController property = this.controller.getProperty(name);
        return property == null ? null : new PropertyBuilder(property, this, this.validatorFactory);
    }

    public boolean isResolvedView() {
        return this.controller.isResolvedView();
    }

    public ControllerBuilder addRequestType(DataType value) {
        this.controller.getRequestTypes().add(value);
        return this;
    }

    public ControllerBuilder removeRequestType(DataType value) {
        this.controller.getRequestTypes().remove(value);
        return this;
    }

    public ControllerBuilder addResponseType(DataType value) {
        this.controller.getResponseTypes().add(value);
        return this;
    }

    public ControllerBuilder removeResponseType(DataType value) {
        this.controller.getResponseTypes().remove(value);
        return this;
    }
}

