/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.brandao.brutos.ActionType;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ConfigurableApplicationContext;
import org.brandao.brutos.ControllerBuilder;
import org.brandao.brutos.ControllerManager;
import org.brandao.brutos.DispatcherType;
import org.brandao.brutos.InterceptorManager;
import org.brandao.brutos.StackRequestElement;
import org.brandao.brutos.ValidatorFactory;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.mapping.ActionListener;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.ControllerID;
import org.brandao.brutos.mapping.MappingException;
import org.brandao.brutos.mapping.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerManagerImp
implements ControllerManager,
ControllerManager.InternalUpdate {
    protected Map<ControllerID, Controller> mappedControllers = new HashMap<ControllerID, Controller>();
    protected Map<Class<?>, Controller> classMappedControllers = new HashMap();
    protected ValidatorFactory validatorFactory;
    protected ControllerBuilder current;
    protected ConfigurableApplicationContext applicationContext;
    protected InterceptorManager interceptorManager;
    protected ControllerManager parent;

    @Override
    public ControllerBuilder addController(Class<?> classtype) {
        return this.addController(null, null, false, null, classtype, null);
    }

    @Override
    public ControllerBuilder addController(String id, Class<?> classType) {
        return this.addController(id, null, false, null, classType, null);
    }

    @Override
    public ControllerBuilder addController(String id, String view, boolean resolvedView, Class<?> classType) {
        return this.addController(id, view, resolvedView, null, classType, null);
    }

    @Override
    public ControllerBuilder addController(String id, String view, boolean resolvedView, String name, Class<?> classType, String actionId) {
        return this.addController(id, view, resolvedView, null, name, classType, actionId);
    }

    @Override
    public ControllerBuilder addController(String id, String view, boolean resolvedView, DispatcherType dispatcherType, String name, Class<?> classType, String actionId) {
        return this.addController(id, view, resolvedView, dispatcherType, name, classType, actionId, null);
    }

    @Override
    public ControllerBuilder addController(String id, String view, boolean resolvedView, DispatcherType dispatcherType, String name, Class<?> classType, String actionId, ActionType actionType) {
        return this.addController(id, view, dispatcherType, resolvedView, name, classType, actionId, actionType);
    }

    @Override
    public ControllerBuilder addController(String id, String view, DispatcherType dispatcherType, boolean resolvedView, String name, Class<?> classType, String actionId, ActionType actionType) {
        id = StringUtil.adjust(id);
        view = StringUtil.adjust(view);
        actionId = StringUtil.adjust(actionId);
        name = StringUtil.adjust(name);
        ControllerID controllerID = new ControllerID(id);
        actionId = actionId == null ? this.applicationContext.getActionParameterName() : actionId;
        dispatcherType = dispatcherType == null ? this.applicationContext.getDispatcherType() : dispatcherType;
        ActionType actionType2 = actionType = actionType == null ? this.applicationContext.getActionType() : actionType;
        if (classType == null) {
            throw new MappingException("invalid class type: " + classType);
        }
        if (actionType == null) {
            throw new MappingException("action type is required");
        }
        if (!actionType.isValidControllerId(id)) {
            throw new MappingException("invalid controller id: " + id);
        }
        Controller controller = new Controller(this.applicationContext);
        controller.setClassType(classType);
        controller.setId(controllerID);
        ActionListener ac = new ActionListener();
        ac.setPreAction(this.getMethodAction("preAction", controller.getClassType()));
        ac.setPostAction(this.getMethodAction("postAction", controller.getClassType()));
        controller.setActionListener(ac);
        controller.setDefaultInterceptorList(this.interceptorManager.getDefaultInterceptors());
        this.current = new ControllerBuilder(controller, this, this.interceptorManager, this.validatorFactory, this.applicationContext, this);
        this.current.setName(name).setView(view, resolvedView).setActionId(actionId).setDispatcherType(dispatcherType).setActionType(actionType);
        this.addController(controller.getId(), controller);
        this.getLogger().info(String.format("added controller %s", classType.getSimpleName()));
        return this.getCurrent();
    }

    protected Method getMethodAction(String methodName, Class<?> classe) {
        try {
            Method method = classe.getDeclaredMethod(methodName, StackRequestElement.class);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean contains(String id) {
        boolean result = this.mappedControllers.containsKey(id);
        return !result && this.parent != null ? this.parent.contains(id) : result;
    }

    @Override
    public Controller getController(String id) {
        Controller controller = this.mappedControllers.get(id);
        if (controller == null && this.parent != null) {
            return this.parent.getController(id);
        }
        return controller;
    }

    @Override
    public Controller getController(Class<?> controllerClass) {
        Controller controller = this.classMappedControllers.get(controllerClass);
        if (controller == null && this.parent != null) {
            return this.parent.getController(controllerClass);
        }
        return controller;
    }

    @Override
    public List<Controller> getControllers() {
        LinkedList<Controller> tmp = new LinkedList<Controller>(this.classMappedControllers.values());
        if (this.parent != null) {
            tmp.addAll(this.parent.getControllers());
        }
        return Collections.unmodifiableList(tmp);
    }

    @Override
    public Iterator<Controller> getAllControllers() {
        return new Iterator<Controller>(){
            private Iterator<Controller> currentIterator;
            private Iterator<Controller> parentIterator;
            private int index = 0;
            private int maxSize;
            {
                this.currentIterator = ControllerManagerImp.this.classMappedControllers.values().iterator();
                this.parentIterator = ControllerManagerImp.this.parent != null ? ControllerManagerImp.this.parent.getControllers().iterator() : null;
                this.maxSize = ControllerManagerImp.this.classMappedControllers.size();
            }

            @Override
            public boolean hasNext() {
                if (this.index < this.maxSize) {
                    return this.currentIterator.hasNext();
                }
                return this.parentIterator != null ? this.parentIterator.hasNext() : false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Controller next() {
                try {
                    if (this.index < this.maxSize) {
                        Controller controller = this.currentIterator.next();
                        return controller;
                    }
                    Controller controller = this.parentIterator != null ? this.parentIterator.next() : null;
                    return controller;
                }
                finally {
                    ++this.index;
                }
            }

            @Override
            public void remove() {
                if (this.index < this.maxSize) {
                    this.currentIterator.remove();
                } else if (this.parentIterator != null) {
                    this.parentIterator.remove();
                }
                --this.index;
            }
        };
    }

    protected synchronized void addController(ControllerID id, Controller controller) {
        if (this.mappedControllers.containsKey(id)) {
            throw new BrutosException(String.format("duplicate controller: %s", id.getName()));
        }
        this.mappedControllers.put(id, controller);
        if (controller.getId().equals(id)) {
            this.classMappedControllers.put(controller.getClassType(), controller);
        }
        this.applicationContext.getActionResolver().registry(id, controller, null, null);
    }

    protected synchronized void removeController(ControllerID id, Controller controller) {
        if (!this.mappedControllers.containsKey(id)) {
            throw new BrutosException(String.format("controller not found: %s", id.getName()));
        }
        this.mappedControllers.remove(id);
        if (controller.getId().equals(id)) {
            if (controller.getId() != null) {
                this.mappedControllers.remove(controller.getId());
            }
            for (ControllerID alias : controller.getAlias()) {
                this.removeController(alias, controller);
            }
            this.classMappedControllers.remove(controller.getClassType());
        }
        this.applicationContext.getActionResolver().registry(id, controller, null, null);
    }

    @Override
    public ControllerBuilder getCurrent() {
        return this.current;
    }

    @Override
    public void setParent(ControllerManager parent) {
        this.parent = parent;
    }

    @Override
    public ControllerManager getParent() {
        return this.parent;
    }

    @Override
    public Logger getLogger() {
        return LoggerProvider.getCurrentLoggerProvider().getLogger(ControllerBuilder.class);
    }

    @Override
    public InterceptorManager getInterceptorManager() {
        return this.interceptorManager;
    }

    @Override
    public void setInterceptorManager(InterceptorManager interceptorManager) {
        this.interceptorManager = interceptorManager;
    }

    @Override
    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    @Override
    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public synchronized void removeController(Class<?> clazz) {
        Controller controller = this.classMappedControllers.get(clazz);
        if (controller != null) {
            this.removeController(controller.getId(), controller);
        }
    }

    @Override
    public synchronized void removeController(String name) {
        ControllerID id = new ControllerID(name);
        Controller controller = this.mappedControllers.get(id);
        if (controller != null) {
            this.removeController(id, controller);
        }
    }

    @Override
    public void addControllerAlias(Controller controller, ControllerID alias) {
        this.addController(alias, controller);
    }

    @Override
    public void removeControllerAlias(Controller controller, ControllerID alias) {
        this.removeController(alias, controller);
    }
}

