/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.InterceptorBuilder;
import org.brandao.brutos.InterceptorManager;
import org.brandao.brutos.InterceptorStackBuilder;
import org.brandao.brutos.interceptor.InterceptorController;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.mapping.Interceptor;
import org.brandao.brutos.mapping.InterceptorStack;
import org.brandao.brutos.mapping.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorManagerImp
implements InterceptorManager {
    private Map<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
    private Map<Class<?>, Interceptor> reverseInterceptors = new HashMap();
    private List<Interceptor> defaultInterceptors = new ArrayList<Interceptor>();
    private InterceptorManager parent;

    public InterceptorManagerImp() {
        this(null);
    }

    public InterceptorManagerImp(InterceptorManager parent) {
        this.parent = parent;
    }

    @Override
    public InterceptorStackBuilder addInterceptorStack(String name, boolean isDefault) {
        String string = name = StringUtil.isEmpty(name) ? null : name;
        if (name == null) {
            throw new BrutosException("interceptor name is required!");
        }
        if (this.interceptors.containsKey(name)) {
            throw new BrutosException("conflict interceptor name: " + name);
        }
        InterceptorStack in = new InterceptorStack();
        if (isDefault) {
            this.defaultInterceptors.add(in);
        }
        in.setName(name);
        in.setDefault(isDefault);
        in.setProperties(new HashMap<String, Object>());
        this.interceptors.put(name, in);
        this.getLogger().info("adding interceptor stack " + name);
        return new InterceptorStackBuilder(in, this);
    }

    @Override
    public InterceptorBuilder addInterceptor(String name, Class<?> interceptor, boolean isDefault) {
        String string = name = StringUtil.isEmpty(name) ? null : name;
        if (interceptor == null) {
            throw new BrutosException("interceptor class is required!");
        }
        if (name == null) {
            throw new BrutosException("interceptor name is required!");
        }
        if (this.interceptors.containsKey(name)) {
            throw new BrutosException("conflict interceptor name: " + name);
        }
        if (this.reverseInterceptors.containsKey(interceptor)) {
            throw new BrutosException("conflict interceptor: " + interceptor.getName());
        }
        if (!InterceptorController.class.isAssignableFrom(interceptor)) {
            throw new BrutosException("must implement interface InterceptorController: " + interceptor.getSimpleName());
        }
        Interceptor in = new Interceptor();
        if (isDefault) {
            this.defaultInterceptors.add(in);
        }
        in.setType(interceptor);
        in.setName(name);
        in.setProperties(new HashMap<String, Object>());
        in.setDefault(isDefault);
        this.interceptors.put(name, in);
        this.reverseInterceptors.put(interceptor, in);
        this.getLogger().info("adding interceptor " + interceptor.getSimpleName());
        return new InterceptorBuilder(in, this);
    }

    @Override
    public Interceptor getInterceptor(String name) {
        if (!this.interceptors.containsKey(name)) {
            if (this.parent != null) {
                return this.parent.getInterceptor(name);
            }
            return null;
        }
        return this.interceptors.get(name);
    }

    @Override
    public boolean containsInterceptor(String name) {
        return this.interceptors.containsKey(name) || this.parent != null && this.parent.containsInterceptor(name);
    }

    @Override
    public Interceptor getInterceptor(Class<?> clazz) {
        if (!this.reverseInterceptors.containsKey(clazz)) {
            if (this.parent != null) {
                return this.parent.getInterceptor(clazz);
            }
            return null;
        }
        return this.reverseInterceptors.get(clazz);
    }

    @Override
    public boolean containsInterceptor(Class<?> clazz) {
        return this.reverseInterceptors.containsKey(clazz) || this.parent != null && this.parent.containsInterceptor(clazz);
    }

    @Override
    public List<Interceptor> getDefaultInterceptors() {
        List<Interceptor> tmp;
        if (this.parent != null) {
            tmp = new ArrayList<Interceptor>(this.parent.getDefaultInterceptors());
            tmp.addAll(this.defaultInterceptors);
        } else {
            tmp = this.defaultInterceptors;
        }
        return Collections.unmodifiableList(tmp);
    }

    @Override
    public void setParent(InterceptorManager parent) {
        this.parent = parent;
    }

    @Override
    public InterceptorManager getParent() {
        return this.parent;
    }

    protected Logger getLogger() {
        return LoggerProvider.getCurrentLoggerProvider().getLogger(InterceptorManager.class);
    }
}

