/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.util.HashMap;
import java.util.Set;
import org.brandao.brutos.InterceptorManager;
import org.brandao.brutos.mapping.Interceptor;
import org.brandao.brutos.mapping.InterceptorStack;
import org.brandao.brutos.mapping.MappingException;

public class InterceptorStackBuilder {
    private Interceptor interceptor;
    private InterceptorManager manager;
    private Interceptor current;

    public InterceptorStackBuilder(Interceptor interceptor, InterceptorManager manager) {
        this.interceptor = interceptor;
        this.manager = manager;
        this.current = interceptor;
    }

    public InterceptorStackBuilder addInterceptor(String interceptorName) {
        Interceptor in = this.manager.getInterceptor(interceptorName);
        if (in == null) {
            throw new MappingException("interceptor not found: " + interceptorName);
        }
        if (in.isDefault()) {
            throw new MappingException("interceptor can't be added in the stack: " + in.getName());
        }
        this.current = new Interceptor(in);
        this.current.setProperties(new HashMap<String, Object>());
        Set<String> keys = in.getProperties().keySet();
        for (String key : keys) {
            Object value = in.getProperties().get(key);
            this.current.getProperties().put(key, value);
        }
        ((InterceptorStack)this.interceptor).addInterceptor(this.current);
        return this;
    }

    public InterceptorStackBuilder addParameter(String name, String value) {
        if (this.current == null) {
            throw new MappingException("addInterceptor() is not invoked!");
        }
        if (name == null || !name.matches("([a-zA-Z0-9_]+)(\\.[a-zA-Z0-9_]+)+")) {
            throw new MappingException("invalid parameter name: " + name);
        }
        this.interceptor.setProperty(name, value);
        return this;
    }
}

