/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.brandao.brutos.ActionResolver;
import org.brandao.brutos.ApplicationContext;
import org.brandao.brutos.BrutosConstants;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.CodeGenerator;
import org.brandao.brutos.ConfigurableApplicationContext;
import org.brandao.brutos.ConfigurableRenderView;
import org.brandao.brutos.ConfigurableRequestParser;
import org.brandao.brutos.ControllerManager;
import org.brandao.brutos.DataType;
import org.brandao.brutos.DefaultMvcRequest;
import org.brandao.brutos.DefaultMvcResponse;
import org.brandao.brutos.InvokerException;
import org.brandao.brutos.MutableMvcRequest;
import org.brandao.brutos.MutableMvcResponse;
import org.brandao.brutos.MutableRequestParserEventImp;
import org.brandao.brutos.MvcRequest;
import org.brandao.brutos.MvcResponse;
import org.brandao.brutos.ObjectFactory;
import org.brandao.brutos.RequestInstrument;
import org.brandao.brutos.RequestInstrumentImp;
import org.brandao.brutos.RequestParserListener;
import org.brandao.brutos.RequestProvider;
import org.brandao.brutos.RequestTypeException;
import org.brandao.brutos.ResourceAction;
import org.brandao.brutos.ResponseProvider;
import org.brandao.brutos.ResponseTypeException;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.Scopes;
import org.brandao.brutos.StackRequest;
import org.brandao.brutos.StackRequestElement;
import org.brandao.brutos.StackRequestElementImp;
import org.brandao.brutos.interceptor.InterceptorHandlerImp;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.DataTypeMap;
import org.brandao.brutos.mapping.PropertyController;
import org.brandao.brutos.scope.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoker {
    private static final ThreadLocal<ConfigurableApplicationContext> currentApp = new ThreadLocal();
    protected Logger logger = LoggerProvider.getCurrentLoggerProvider().getLogger(Invoker.class);
    protected ObjectFactory objectFactory;
    protected ControllerManager controllerManager;
    protected ActionResolver actionResolver;
    protected ConfigurableApplicationContext applicationContext;
    protected ConfigurableRenderView renderView;
    protected ConfigurableRequestParser requestParser;
    protected RequestParserListener requestParserListener;
    protected CodeGenerator codeGenerator;

    public CodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    public void setCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ControllerManager getControllerManager() {
        return this.controllerManager;
    }

    public void setControllerManager(ControllerManager controllerManager) {
        this.controllerManager = controllerManager;
    }

    public ActionResolver getActionResolver() {
        return this.actionResolver;
    }

    public void setActionResolver(ActionResolver actionResolver) {
        this.actionResolver = actionResolver;
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ConfigurableRenderView getRenderView() {
        return this.renderView;
    }

    public void setRenderView(ConfigurableRenderView renderView) {
        this.renderView = renderView;
    }

    public ConfigurableRequestParser getRequestParser() {
        return this.requestParser;
    }

    public void setRequestParser(ConfigurableRequestParser requestParser) {
        this.requestParser = requestParser;
    }

    public RequestParserListener getRequestParserListener() {
        return this.requestParserListener;
    }

    public void setRequestParserListener(RequestParserListener requestParserListener) {
        this.requestParserListener = requestParserListener;
    }

    public RequestInstrument getRequestInstrument() {
        Scopes scopes = this.applicationContext.getScopes();
        Scope requestScope = scopes.get(ScopeType.REQUEST);
        RequestInstrument requestInstrument = this.getRequestInstrument(requestScope);
        return requestInstrument;
    }

    public StackRequest getStackRequest() {
        RequestInstrument requestInstrument = this.getRequestInstrument();
        return this.getStackRequest(requestInstrument);
    }

    public StackRequest getStackRequest(RequestInstrument value) {
        return (StackRequest)((Object)value);
    }

    public StackRequestElement getStackRequestElement() {
        return this.getStackRequest().getCurrent();
    }

    public Object invoke(Controller controller, ResourceAction action, Object[] parameters) throws InvokerException {
        return this.invoke(controller, action, null, parameters);
    }

    public Object invoke(Controller controller, ResourceAction action, Object resource, Object[] parameters) throws InvokerException {
        if (controller == null) {
            throw new InvokerException("controller not found");
        }
        if (action == null) {
            throw new InvokerException("action not found");
        }
        DefaultMvcRequest request = new DefaultMvcRequest();
        DefaultMvcResponse response = new DefaultMvcResponse();
        request.setResource(resource);
        request.setResourceAction(action);
        request.setParameters(parameters);
        this.invoke(request, response);
        return response.getResult();
    }

    public Object invoke(Class<?> controllerClass, String actionId) {
        Controller controller = this.applicationContext.getControllerManager().getController(controllerClass);
        ResourceAction resourceAction = this.actionResolver.getResourceAction(controller, actionId, (MutableMvcRequest)RequestProvider.getRequest());
        if (resourceAction == null) {
            return false;
        }
        return this.invoke(controller, resourceAction, null);
    }

    public boolean invoke(MutableMvcRequest request, MutableMvcResponse response) throws InvokerException {
        boolean bl;
        request.setApplicationContext(this.applicationContext);
        if (!this.resolveAction(request, response)) {
            return false;
        }
        boolean pushStackRequest = false;
        StackRequest stackRequest = null;
        MvcRequest oldRequest = null;
        MvcResponse oldresponse = null;
        try {
            currentApp.set(this.applicationContext);
            StackRequestElement element = this.createStackRequestElement();
            oldRequest = RequestProvider.init(request);
            oldresponse = ResponseProvider.init(response);
            RequestInstrument requestInstrument = this.getRequestInstrument();
            stackRequest = this.getStackRequest(requestInstrument);
            request.setRequestInstrument(requestInstrument);
            request.setStackRequestElement(element);
            stackRequest.push(element);
            pushStackRequest = true;
            this.invokeApplication(request, response, element, requestInstrument);
            if (!requestInstrument.isHasViewProcessed()) {
                this.renderView(requestInstrument, request, response, element);
            }
            bl = true;
        }
        catch (Throwable e) {
            try {
                throw new InvokerException(e);
            }
            catch (Throwable throwable) {
                RequestProvider.destroy(oldRequest);
                ResponseProvider.destroy(oldresponse);
                if (pushStackRequest) {
                    stackRequest.pop();
                }
                currentApp.remove();
                throw throwable;
            }
        }
        RequestProvider.destroy(oldRequest);
        ResponseProvider.destroy(oldresponse);
        if (pushStackRequest) {
            stackRequest.pop();
        }
        currentApp.remove();
        return bl;
    }

    protected void resolveTypes(MutableMvcRequest request, MutableMvcResponse response) throws RequestTypeException {
        ResourceAction resourceAction = request.getResourceAction();
        if (!this.isSupportedRequestType(resourceAction, request)) {
            throw new RequestTypeException("request type not supported");
        }
        DataType responseDataType = this.selectResponseType(resourceAction, request);
        if (responseDataType == null) {
            throw new ResponseTypeException("response type not supported");
        }
        response.setType(responseDataType);
    }

    protected boolean resolveAction(MutableMvcRequest request, MutableMvcResponse response) {
        if (request.getResourceAction() != null) {
            request.setResource(request.getResourceAction().getController().getInstance(this.objectFactory));
            return true;
        }
        ResourceAction resourceAction = this.actionResolver.getResourceAction(this.controllerManager, request);
        if (resourceAction == null) {
            return false;
        }
        request.setResource(resourceAction.getController().getInstance(this.objectFactory));
        request.setResourceAction(resourceAction);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRequest(MutableMvcRequest request, MutableMvcResponse response) {
        MutableRequestParserEventImp event = new MutableRequestParserEventImp();
        event.setRequest(request);
        event.setResponse(response);
        try {
            this.requestParserListener.started(event);
            this.requestParser.parserContentType(request, request.getType(), this.applicationContext.getConfiguration(), event, this.codeGenerator);
        }
        finally {
            this.requestParserListener.finished(event);
        }
    }

    protected void updateRequest(MutableMvcRequest request, Controller controller, Object resource) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List<PropertyController> properties = controller.getProperties();
        for (PropertyController property : properties) {
            if (!property.canGet()) continue;
            Object value = property.getValueFromSource(resource);
            Scope scope = this.applicationContext.getScopes().get(property.getScopeType());
            if (scope == null) {
                throw new BrutosException("scope not found " + property.getScopeType());
            }
            if (value != null) {
                scope.put(property.getName(), value);
            } else {
                scope.remove(property.getName());
            }
            request.setProperty(property.getName(), value);
        }
    }

    protected void invokeApplication(MutableMvcRequest request, MutableMvcResponse response, StackRequestElement element, RequestInstrument requestInstrument) throws Throwable {
        this.resolveTypes(request, response);
        try {
            this.parseRequest(request, response);
        }
        catch (Throwable e) {
            request.setThrowable(e);
        }
        element.setAction(request.getResourceAction());
        element.setController(request.getResourceAction().getController());
        element.setRequest(request);
        element.setResponse(response);
        element.setResource(request.getResource());
        element.setObjectThrow(request.getThrowable());
        InterceptorHandlerImp ih = new InterceptorHandlerImp(request, response);
        Controller controller = element.getController();
        controller.proccessBrutosAction(ih);
    }

    protected void renderView(RequestInstrument requestInstrument, MutableMvcRequest request, MutableMvcResponse response, StackRequestElement element) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.updateRequest(request, element.getController(), element.getResource());
        this.renderView.show(request, response);
        requestInstrument.setHasViewProcessed(true);
    }

    protected boolean isSupportedRequestType(ResourceAction action, MutableMvcRequest request) {
        DataTypeMap supportedRequestTypes = action.getRequestTypes();
        if (supportedRequestTypes.isEmpty()) {
            return true;
        }
        return supportedRequestTypes.accept(request.getType());
    }

    protected DataType selectResponseType(ResourceAction action, MutableMvcRequest request) {
        DataTypeMap supportedResponseTypes = action.getResponseTypes();
        List<DataType> responseTypes = request.getAcceptResponse();
        if (supportedResponseTypes.isEmpty()) {
            DataType defaultDataType = this.renderView.getDefaultRenderViewType();
            for (DataType dataType : responseTypes) {
                if (!defaultDataType.equals(dataType)) continue;
                return dataType;
            }
        } else {
            for (DataType dataType : responseTypes) {
                if (!supportedResponseTypes.accept(dataType)) continue;
                return dataType;
            }
        }
        return null;
    }

    private RequestInstrument getRequestInstrument(Scope scope) {
        RequestInstrument requestInstrument = (RequestInstrument)scope.get(BrutosConstants.REQUEST_INSTRUMENT);
        if (requestInstrument == null) {
            requestInstrument = new RequestInstrumentImp(this.applicationContext, this.objectFactory, this.renderView);
            scope.put(BrutosConstants.REQUEST_INSTRUMENT, requestInstrument);
        }
        return requestInstrument;
    }

    protected StackRequestElement createStackRequestElement() {
        return new StackRequestElementImp();
    }

    public static ApplicationContext getCurrentApplicationContext() {
        return currentApp.get();
    }

    public static Invoker getInstance() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)Invoker.getCurrentApplicationContext();
        if (context == null) {
            throw new BrutosException("can't get invoker");
        }
        return context.getInvoker();
    }

    public void flush() {
    }
}

