/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import org.brandao.brutos.BeanBuilder;
import org.brandao.brutos.BrutosConstants;
import org.brandao.brutos.ControllerBuilder;
import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.FetchType;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.ValidatorFactory;
import org.brandao.brutos.mapping.DependencyBean;
import org.brandao.brutos.mapping.MappingBeanUtil;
import org.brandao.brutos.mapping.MappingException;
import org.brandao.brutos.mapping.MetaBean;
import org.brandao.brutos.mapping.StringUtil;
import org.brandao.brutos.type.DateTimeType;
import org.brandao.brutos.type.EnumType;
import org.brandao.brutos.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBeanBuilder {
    private MetaBean metaBean;
    private EnumerationType enumProperty;
    private String temporalProperty;
    private ValidatorFactory validatorFactory;
    private ControllerBuilder controller;
    private String origin;

    public MetaBeanBuilder(MetaBean metaBean, String name, ScopeType scope, EnumerationType enumProperty, String temporalProperty, Class<?> classType, Type type, ValidatorFactory validatorFactory, ControllerBuilder controller, String origin) {
        this.metaBean = metaBean;
        this.enumProperty = enumProperty;
        this.temporalProperty = temporalProperty;
        this.validatorFactory = validatorFactory;
        this.controller = controller;
        if (type == null) {
            type = this.metaBean.getController().getContext().getTypeManager().getType(classType, this.enumProperty, this.temporalProperty);
        }
        this.setScope(scope);
        this.setName(name);
        this.setClassType(classType);
        this.setType(type);
    }

    public MetaBeanBuilder addMetaValue(Object value, String mapping) {
        return this.addMetaValue(value, BrutosConstants.DEFAULT_ENUMERATIONTYPE, "yyyy-MM-dd", mapping, BrutosConstants.DEFAULT_SCOPETYPE, null, null);
    }

    public BeanBuilder buildMetaValue(Object value, Class<?> clazz) {
        String beanName = this.origin + "#" + this.metaBean.getName() + "#" + this.metaBean.getSize();
        BeanBuilder beanBuilder = this.controller.buildMappingBean(beanName, clazz);
        this.addMetaValue(value, beanName);
        return beanBuilder;
    }

    public MetaBeanBuilder addMetaValue(Object value, EnumerationType enumProperty, String temporalProperty, String mapping, ScopeType scope, Type typeDef, Object type) {
        if (type == null && mapping == null) {
            throw new MappingException("unknown bean type");
        }
        DependencyBean dependency = MappingBeanUtil.createMetaBeanValue(enumProperty, temporalProperty, mapping, scope, null, false, false, typeDef, type, this.metaBean, FetchType.EAGER, this.validatorFactory, this.controller.controller);
        Object metaValue = this.metaBean.getType().convert(value);
        this.metaBean.putMetaValue(metaValue, dependency);
        return this;
    }

    public MetaBeanBuilder removeMetaValue(String value) {
        this.metaBean.removeMetaValue(value);
        return this;
    }

    public MetaBeanBuilder setName(String name) {
        if (StringUtil.isEmpty(name = StringUtil.adjust(name))) {
            throw new IllegalArgumentException("meta bean name cannot be empty");
        }
        this.metaBean.setName(name);
        return this;
    }

    public String getName() {
        return this.metaBean.getName();
    }

    public MetaBeanBuilder setScope(ScopeType scope) {
        if (scope == null) {
            throw new NullPointerException("scope of meta bean cannot be null");
        }
        this.metaBean.setScopeType(scope);
        return this;
    }

    public ScopeType getScope() {
        return this.metaBean.getScopeType();
    }

    public MetaBeanBuilder setEnumProperty(EnumerationType enumProperty) {
        Type type = this.metaBean.getType();
        if (!(type instanceof EnumType)) {
            throw new MappingException("enumProperty not supported");
        }
        ((EnumType)type).setEnumerationType(enumProperty);
        return this;
    }

    public EnumerationType getEnumProperty(EnumerationType enumProperty) {
        Type type = this.metaBean.getType();
        this.enumProperty = enumProperty;
        if (type instanceof EnumType) {
            return ((EnumType)type).getEnumerationType();
        }
        return null;
    }

    public MetaBeanBuilder setTemporalProperty(String pattern) {
        Type type = this.metaBean.getType();
        this.temporalProperty = pattern;
        if (!(type instanceof DateTimeType)) {
            throw new MappingException("temporalProperty not supported");
        }
        ((DateTimeType)type).setPattern(pattern);
        return this;
    }

    public String getTemporalProperty() {
        Type type = this.metaBean.getType();
        if (type instanceof DateTimeType) {
            return ((DateTimeType)type).getPattern();
        }
        return null;
    }

    public MetaBeanBuilder setClassType(Class<?> classType) {
        this.metaBean.setClassType(classType);
        return this;
    }

    public Class<?> getClassType() {
        return this.metaBean.getType().getClassType();
    }

    public MetaBeanBuilder setType(Type type) {
        this.metaBean.setType(type);
        return this;
    }

    public Type getType() {
        return this.metaBean.getType();
    }
}

