/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.brandao.brutos.ApplicationContext;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.Invoker;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.scope.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scopes {
    private Map<String, Scope> scopes = new HashMap<String, Scope>();

    public void register(String id, Scope scope) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (scope == null) {
            throw new NullPointerException("scope");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info((this.scopes.containsKey(id) ? "override scope " : "adding scope ") + id);
        }
        this.scopes.put(id, scope);
    }

    public void remove(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("removed scope: " + id);
        }
        this.scopes.remove(id);
    }

    public Scope get(String id) {
        return this.scopes.get(id);
    }

    public Scope get(ScopeType scopeId) {
        return this.get(scopeId.toString());
    }

    public Map<String, Scope> getScopes() {
        return Collections.unmodifiableMap(this.scopes);
    }

    void clear() {
        this.scopes.clear();
    }

    public Logger getLogger() {
        return LoggerProvider.getCurrentLoggerProvider().getLogger(Scopes.class.getName());
    }

    public static Scope getCurrentScope(ScopeType value) {
        ApplicationContext context = Invoker.getCurrentApplicationContext();
        if (context == null) {
            throw new BrutosException("could not get context");
        }
        Scope objectScope = context.getScopes().get(value);
        if (objectScope == null) {
            throw new BrutosException("scope not found in context: " + value);
        }
        return objectScope;
    }
}

