/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.bean.BeanData;
import org.brandao.brutos.bean.BeanProperty;
import org.brandao.brutos.bean.BeanPropertyImp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInstance {
    private static Map<Class<?>, BeanData> cache = new HashMap();
    private Object object;
    private Class<?> clazz;
    private BeanData data;

    public BeanInstance(Object object) {
        this(object, object.getClass());
    }

    public BeanInstance(Object object, Class<?> clazz) {
        this.object = object;
        this.clazz = clazz;
        this.data = this.getBeanData(this.clazz);
    }

    public void set(String property, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.getProperty(property).set(this.object, value);
    }

    public Object get(String property) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getProperty(property).get(this.object);
    }

    public void set(String property, Object source, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.getProperty(property).set(source, value);
    }

    public Object get(String property, Object source) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getProperty(property).get(source);
    }

    public BeanProperty getProperty(String property) {
        BeanProperty prop = this.data.getProperty(property);
        if (prop == null) {
            throw new BrutosException("not found: " + this.clazz.getName() + "." + property);
        }
        return prop;
    }

    private void loadFields(BeanData data, Set<String> transientMethods, Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            this.loadFields(data, transientMethods, superClass);
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || transientMethods.contains(f.getName())) continue;
            data.addProperty(f.getName(), new BeanPropertyImp(f, null, null, f.getName()));
            data.getSetter().put(f.getName(), f);
            data.getGetter().put(f.getName(), f);
        }
    }

    private Set<String> getTransientProperties(Class<?> clazz) {
        HashSet<String> result = new HashSet<String>();
        try {
            Method method = clazz.getDeclaredMethod("getTransientProperties", new Class[0]);
            if (Modifier.isStatic(method.getModifiers()) && Modifier.isProtected(method.getModifiers())) {
                method.setAccessible(true);
                String[] properties = (String[])method.invoke(clazz, new Object[0]);
                if (properties != null) {
                    Collections.addAll(result, properties);
                }
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw new BrutosException(e.getTargetException());
        }
        catch (Throwable e) {
            return result;
        }
    }

    private void loadMethods(BeanData data, Set<String> transientMethods, Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> type;
            BeanProperty prop;
            String propertyName;
            Method method = methods[i];
            String methodName = method.getName();
            if (methodName.equals("getClass") || (propertyName = this.getPropertyName(method)) == null || transientMethods.contains(propertyName)) continue;
            if (this.isSet(method)) {
                prop = data.getProperty(propertyName);
                type = method.getParameterTypes()[0];
                if (prop != null) {
                    if (prop.getField() != null && type.isAssignableFrom(prop.getField().getType())) {
                        prop.setSet(method);
                        continue;
                    }
                    if (prop.getGet() == null || !type.isAssignableFrom(prop.getGet().getReturnType())) continue;
                    prop.setSet(method);
                    continue;
                }
                data.addProperty(propertyName, new BeanPropertyImp(null, method, null, propertyName));
                continue;
            }
            if (!this.isGet(method)) continue;
            prop = data.getProperty(propertyName);
            type = method.getReturnType();
            if (prop != null) {
                if (prop.getField() != null && type.isAssignableFrom(prop.getField().getType())) {
                    prop.setGet(method);
                    continue;
                }
                if (prop.getSet() == null || !type.isAssignableFrom(prop.getSet().getParameterTypes()[0])) continue;
                prop.setGet(method);
                continue;
            }
            data.addProperty(propertyName, new BeanPropertyImp(null, null, method, propertyName));
        }
    }

    private boolean isGet(Method method) {
        String methodName = method.getName();
        return methodName.startsWith("get") && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE || methodName.startsWith("is") && method.getParameterTypes().length == 0 && ClassUtil.getWrapper(method.getReturnType()) == Boolean.class;
    }

    private boolean isSet(Method method) {
        String methodName = method.getName();
        return methodName.startsWith("set") && method.getParameterTypes().length == 1;
    }

    private String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("set") && method.getParameterTypes().length == 1) {
            String id = methodName.substring(3, methodName.length());
            return Character.toLowerCase(id.charAt(0)) + id.substring(1, id.length());
        }
        if (methodName.startsWith("get") && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
            String id = methodName.substring(3, methodName.length());
            return Character.toLowerCase(id.charAt(0)) + id.substring(1, id.length());
        }
        if (methodName.startsWith("is") && method.getParameterTypes().length == 0 && ClassUtil.getWrapper(method.getReturnType()) == Boolean.class) {
            String id = methodName.substring(2, methodName.length());
            return Character.toLowerCase(id.charAt(0)) + id.substring(1, id.length());
        }
        return null;
    }

    private BeanData getBeanData(Class<?> clazz) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        BeanData data = new BeanData();
        data.setClassType(clazz);
        Set<String> transientMethods = this.getTransientProperties(clazz);
        this.loadFields(data, transientMethods, clazz);
        this.loadMethods(data, transientMethods, clazz);
        cache.put(clazz, data);
        return data;
    }

    public boolean containProperty(String property) {
        return this.data.getProperties().containsKey(property);
    }

    public Class<?> getType(String property) {
        BeanProperty prop = this.data.getProperty(property);
        if (prop == null) {
            throw new BrutosException("not found: " + this.clazz.getName() + "." + property);
        }
        return prop.getType();
    }

    public Object getGenericType(String property) {
        BeanProperty prop = this.data.getProperty(property);
        if (prop == null) {
            throw new BrutosException("not found: " + this.clazz.getName() + "." + property);
        }
        return prop.getGenericType();
    }

    public Class<?> getClassType() {
        return this.clazz;
    }

    public List<BeanProperty> getProperties() {
        return new LinkedList<BeanProperty>(this.data.getProperties().values());
    }
}

