/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.brandao.brutos.bean.BeanException;
import org.brandao.brutos.bean.BeanProperty;

public class BeanPropertyImp
implements BeanProperty {
    private Field field;
    private Method set;
    private Method get;
    private String name;

    public BeanPropertyImp(Field field, Method set, Method get, String name) {
        this.field = field;
        this.set = set;
        this.get = get;
        this.name = name;
    }

    public boolean canSet() {
        return this.set != null || this.field != null;
    }

    public void set(Object o, Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.set != null) {
            this.set.invoke(o, value);
        } else {
            this.field.setAccessible(true);
            this.field.set(o, value);
        }
    }

    public boolean canGet() {
        return this.get != null || this.field != null;
    }

    public Object get(Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.get != null) {
            return this.get.invoke(o, new Object[0]);
        }
        this.field.setAccessible(true);
        return this.field.get(o);
    }

    public Object getGenericType() {
        try {
            if (this.get != null) {
                return this.getGenericReturnType(this.get);
            }
            return this.getGenericType(this.field);
        }
        catch (NoSuchMethodException e) {
            return this.getType();
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    private Object getGenericType(Field field) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> fieldClass = field.getClass();
        Method getGenericReturnType = fieldClass.getMethod("getGenericType", new Class[0]);
        return getGenericReturnType.invoke((Object)field, new Object[0]);
    }

    private Object getGenericReturnType(Method method) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> methodClass = method.getClass();
        Method getGenericReturnType = methodClass.getMethod("getGenericReturnType", new Class[0]);
        return getGenericReturnType.invoke((Object)method, new Object[0]);
    }

    public Class getType() {
        if (this.get != null) {
            return this.getReturnType(this.get);
        }
        return this.getType(this.field);
    }

    private Class getType(Field field) {
        return field.getType();
    }

    private Class getReturnType(Method method) {
        return method.getReturnType();
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Method getSet() {
        return this.set;
    }

    public void setSet(Method set) {
        this.set = set;
    }

    public Method getGet() {
        return this.get;
    }

    public void setGet(Method get) {
        this.get = get;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getDeclaredGenericType() {
        return this.getGenericType();
    }

    public Class getDeclaredType() {
        return this.getType();
    }
}

