/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.brandao.brutos.BrutosException;

public class EnumUtil {
    private Class enumClass;
    private Map indexMap;
    private Map nameMap;

    public EnumUtil(Class enumClass) {
        this.enumClass = enumClass;
        this.indexMap = new HashMap();
        this.nameMap = new HashMap();
        int maxIndex = this.getEnumConstantLength();
        for (int i = 0; i < maxIndex; ++i) {
            Enum e = (Enum)this.getEnumConstant(new Integer(i));
            this.indexMap.put(String.valueOf(e.ordinal()), e);
            this.nameMap.put(e.name(), e);
        }
    }

    public Object getEnumConstants() {
        return EnumUtil.getEnumConstants(this.enumClass);
    }

    public static Object getEnumConstants(Class clazz) {
        try {
            Method m = Class.class.getMethod("getEnumConstants", new Class[0]);
            return m.invoke((Object)clazz, new Object[0]);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    public Object valueOf(String value) {
        return EnumUtil.valueOf(this.enumClass, value);
    }

    public Object valueByName(String name) {
        return this.nameMap.get(name);
    }

    public Object valueByIndex(String index) {
        return this.indexMap.get(index);
    }

    public int getEnumConstantLength() {
        return EnumUtil.getEnumConstantLength(this.enumClass);
    }

    public Object getEnumConstant(Integer index) {
        return EnumUtil.getEnumConstant(this.enumClass, index);
    }

    public static int getEnumConstantLength(Class enumClazz) {
        Object cons = EnumUtil.getEnumConstants(enumClazz);
        return Array.getLength(cons);
    }

    public static Object getEnumConstant(Class enumClazz, Integer index) {
        Object cons = EnumUtil.getEnumConstants(enumClazz);
        return Array.get(cons, index);
    }

    public static Object valueOf(Class enumClazz, String value) {
        try {
            Class<?> clazz = Class.forName("java.lang.Enum");
            Method m = clazz.getMethod("valueOf", Class.class, String.class);
            return m.invoke(clazz, enumClazz, value);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }
}

