/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ObjectFactory;

public class JSR299ObjectFactory
implements ObjectFactory {
    private BeanManager beanManager;
    private Properties config;

    public Object getBean(String name) {
        if (name == null) {
            return null;
        }
        Set beans = this.beanManager.getBeans(name);
        return this.getInstance(beans, null);
    }

    public Object getBean(Class clazz) {
        Set beans = this.beanManager.getBeans((Type)clazz, new Annotation[0]);
        return this.getInstance(beans, clazz);
    }

    protected Object getInstance(Set beans, Class clazz) {
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return this.beanManager.getReference(bean, (Type)(clazz == null ? bean.getBeanClass() : clazz), ctx);
    }

    public void configure(Properties properties) {
        this.config = properties;
        this.initBeanManager(this.config);
    }

    public void destroy() {
        this.beanManager = null;
    }

    public void initBeanManager(Properties config) {
        String beanManagerName = null;
        try {
            String jndiClass = config.getProperty("org.brandao.brutos.jndi.class");
            String jndiURL = config.getProperty("org.brandao.brutos.jndi.url");
            Hashtable<String, String> args = new Hashtable<String, String>();
            if (jndiClass != null) {
                args.put("java.naming.factory.initial", jndiClass);
            }
            if (jndiURL != null) {
                args.put("java.naming.provider.url", jndiURL);
            }
            beanManagerName = config.getProperty("org.brandao.brutos.cdi.bean_manager", "java:comp/BeanManager");
            InitialContext initialContext = new InitialContext(args);
            this.beanManager = (BeanManager)initialContext.lookup(beanManagerName);
        }
        catch (NamingException e) {
            throw new BrutosException("Could not get the BeanManager: " + beanManagerName, e);
        }
    }
}

