/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.interceptor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.brandao.brutos.ResourceAction;
import org.brandao.brutos.interceptor.InterceptorController;
import org.brandao.brutos.interceptor.InterceptorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterceptor
implements InterceptorController {
    protected Map<String, Object> props;
    private Set<String> excludeMethods;

    @Override
    public boolean accept(InterceptorHandler handler) {
        ResourceAction rm = handler.getResourceAction();
        if (rm != null && this.excludeMethods != null) {
            return !this.excludeMethods.contains(rm.getMethod().getName());
        }
        return true;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.props = props;
        if (props != null && props.containsKey("excludeMethods")) {
            String em = (String)props.get("excludeMethods");
            String[] ems = em.split(",");
            this.excludeMethods = new HashSet<String>(Arrays.asList(ems));
        }
    }

    @Override
    public boolean isConfigured() {
        return this.props != null;
    }
}

