/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ConfigurableApplicationContext;
import org.brandao.brutos.MutableMvcResponse;
import org.brandao.brutos.RedirectException;
import org.brandao.brutos.ResourceAction;
import org.brandao.brutos.StackRequestElement;
import org.brandao.brutos.interceptor.ConfigurableInterceptorHandler;
import org.brandao.brutos.interceptor.InterceptedException;
import org.brandao.brutos.interceptor.InterceptorController;
import org.brandao.brutos.interceptor.InterceptorEntry;
import org.brandao.brutos.interceptor.InterceptorHandler;
import org.brandao.brutos.interceptor.InterceptorProcessConfigurationBuilder;
import org.brandao.brutos.interceptor.InterceptorStack;
import org.brandao.brutos.logger.Logger;
import org.brandao.brutos.logger.LoggerProvider;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.mapping.ActionListener;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.Interceptor;
import org.brandao.brutos.mapping.ThrowableSafeData;
import org.brandao.brutos.validator.ValidatorException;

public class InterceptorProcess
implements InterceptorStack {
    private Logger logger = LoggerProvider.getCurrentLoggerProvider().getLogger(InterceptorProcess.class.getName());
    private Controller form;
    private InterceptorEntry start;
    private ThreadLocal<InterceptorEntry> stackPos = new ThreadLocal();

    public synchronized void reset() {
        this.start = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InterceptorHandler handler) {
        InterceptorEntry oldPos = null;
        try {
            oldPos = this.stackPos.get();
            this.stackPos.set(this.start);
            this.next(handler);
        }
        finally {
            if (oldPos == null) {
                this.stackPos.remove();
            } else {
                this.stackPos.set(oldPos);
            }
        }
    }

    public synchronized void flush() {
        InterceptorProcessConfigurationBuilder ipcb = new InterceptorProcessConfigurationBuilder(this.form);
        this.start = ipcb.getStack();
    }

    public Controller getForm() {
        return this.form;
    }

    public void setForm(Controller form) {
        this.form = form;
    }

    public void next(InterceptorHandler handler) throws InterceptedException {
        InterceptorEntry pos = this.stackPos.get();
        InterceptorEntry next = pos.getNext();
        this.stackPos.set(next);
        if (next != null) {
            this.next(handler, next);
        } else {
            this.invoke((ConfigurableInterceptorHandler)handler);
        }
    }

    private void next(InterceptorHandler handler, InterceptorEntry pos) throws InterceptedException {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)handler.getContext();
        Interceptor i = pos.getInterceptor();
        InterceptorController interceptor = (InterceptorController)i.getInstance(context.getObjectFactory());
        if (!interceptor.isConfigured()) {
            interceptor.setProperties(i.getProperties());
        }
        if (interceptor.accept(handler)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.form.getClassType().getName() + " intercepted by: " + i.getName());
            }
            interceptor.intercepted(this, handler);
        } else {
            this.next(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(ConfigurableInterceptorHandler handler) {
        StackRequestElement stackRequestElement = handler.getRequest().getStackRequestElement();
        Throwable objectThrow = stackRequestElement.getObjectThrow();
        Object resource = handler.getResource();
        try {
            this.preAction(resource, stackRequestElement);
            if (objectThrow == null) {
                this.invoke0(handler, stackRequestElement);
            } else {
                this.processException(stackRequestElement, objectThrow, stackRequestElement.getAction());
            }
        }
        finally {
            this.postAction(resource, stackRequestElement);
        }
    }

    private void executeAction(ConfigurableInterceptorHandler handler) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, ParseException {
        if (handler.getResourceAction() == null) {
            return;
        }
        Object[] args = handler.getParameters();
        ResourceAction action = handler.getResourceAction();
        Object source = handler.getResource();
        try {
            Object result = action.invoke(source, args);
            MutableMvcResponse response = (MutableMvcResponse)handler.getResponse();
            response.setResult(result);
            handler.getRequest().getStackRequestElement().setResultAction(result);
        }
        catch (IllegalArgumentException ex) {
            StringBuilder argsText = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                argsText = argsText.length() == 0 ? argsText.append(arg) : argsText.append(", ").append(arg);
            }
            StringBuilder exText = new StringBuilder();
            exText.append("can't invoke the action: ").append(source.getClass().getName()).append(".").append(action.getMethod().getName()).append("(").append((CharSequence)argsText).append(")");
            throw new IllegalArgumentException(exText.toString(), ex);
        }
    }

    public void invoke0(ConfigurableInterceptorHandler handler, StackRequestElement stackRequestElement) {
        try {
            this.executeAction(handler);
        }
        catch (ValidatorException e) {
            this.processException(handler.getRequest().getStackRequestElement(), e, handler.getResourceAction());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RedirectException) {
                RedirectException re = (RedirectException)e.getTargetException();
                stackRequestElement.setView(re.getView());
                stackRequestElement.setDispatcherType(re.getDispatcher());
            } else {
                this.processException(stackRequestElement, e.getTargetException(), stackRequestElement.getAction());
            }
        }
        catch (BrutosException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }

    private void processException(StackRequestElement stackRequestElement, Throwable e, ResourceAction resourceAction) {
        Action method = resourceAction == null ? null : resourceAction.getMethodForm();
        ThrowableSafeData tdata = null;
        tdata = method != null ? method.getThrowsSafe(e.getClass()) : this.form.getThrowsSafe(e.getClass());
        if (tdata == null) {
            if (e instanceof BrutosException) {
                throw (BrutosException)e;
            }
            throw new InterceptedException(e);
        }
        stackRequestElement.getRequest().setThrowable(e);
        stackRequestElement.setObjectThrow(e);
        stackRequestElement.setThrowableSafeData(tdata);
    }

    private void preAction(Object source, StackRequestElement element) {
        try {
            ActionListener action = this.form.getActionListener();
            if (action.getPreAction() != null) {
                action.getPreAction().setAccessible(true);
                action.getPreAction().invoke(source, element);
            }
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    private void postAction(Object source, StackRequestElement element) {
        try {
            ActionListener action = this.form.getActionListener();
            if (action.getPostAction() != null) {
                action.getPostAction().setAccessible(true);
                action.getPostAction().invoke(source, element);
            }
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }
}

