/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brandao.brutos.interceptor.InterceptorEntry;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.Interceptor;
import org.brandao.brutos.mapping.InterceptorStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorProcessConfigurationBuilder {
    private Controller controller;

    public InterceptorProcessConfigurationBuilder(Controller controller) {
        this.controller = controller;
    }

    public InterceptorEntry getStack() {
        InterceptorEntry flow;
        ArrayList<Interceptor> stack = new ArrayList<Interceptor>();
        for (Interceptor i : this.controller.getDefaultInterceptorList()) {
            this.buildStack(i, stack);
        }
        for (Interceptor i : this.controller.getInterceptors()) {
            this.buildStack(i, stack);
        }
        InterceptorEntry root = flow = new InterceptorEntry(null);
        for (Interceptor i : stack) {
            InterceptorEntry next = new InterceptorEntry(i);
            flow.setNext(next);
            flow = next;
        }
        return root;
    }

    private void buildStack(Interceptor navigableInterceptor, List<Interceptor> interceptorStack) {
        this.buildStack(navigableInterceptor, navigableInterceptor, interceptorStack);
    }

    private void buildStack(Interceptor root, Interceptor navigableInterceptor, List<Interceptor> interceptorStack) {
        if (navigableInterceptor instanceof InterceptorStack) {
            InterceptorStack stack = (InterceptorStack)navigableInterceptor;
            for (Interceptor i : stack.getInterceptors()) {
                this.buildStack(root, i, interceptorStack);
            }
        } else {
            Interceptor configuredInterceptor = new Interceptor(navigableInterceptor);
            Map<String, Object> configuration = this.buildConfiguration(root, navigableInterceptor);
            configuredInterceptor.setProperties(configuration);
            interceptorStack.add(configuredInterceptor);
        }
    }

    private Map<String, Object> buildConfiguration(Interceptor navigableInterceptor, Interceptor interceptor) {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        this.buildConfiguration(navigableInterceptor, interceptor, configuration);
        return configuration;
    }

    private StringBuilder buildConfiguration(Interceptor navigableInterceptor, Interceptor interceptor, Map<String, Object> configuration) {
        if (navigableInterceptor instanceof InterceptorStack) {
            InterceptorStack stack = (InterceptorStack)navigableInterceptor;
            for (Interceptor i : stack.getInterceptors()) {
                StringBuilder reversePath = this.buildConfiguration(i, interceptor, configuration);
                if (reversePath == null) continue;
                reversePath = reversePath.insert(0, ".").insert(0, i.getName());
                this.transferConfig(reversePath.toString(), stack.getProperties(), configuration);
                return reversePath;
            }
            return null;
        }
        if (interceptor.equals(navigableInterceptor)) {
            this.transferConfig(null, interceptor.getProperties(), configuration);
            return new StringBuilder();
        }
        return null;
    }

    private void transferConfig(String prefix, Map<String, Object> origin, Map<String, Object> dest) {
        for (String key : origin.keySet()) {
            if (prefix != null && !key.startsWith(prefix)) continue;
            dest.put(prefix == null ? key : key.substring(prefix.length()), origin.get(key));
        }
    }
}

