/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.io.ClassPathResource;
import org.brandao.brutos.io.Resource;
import org.brandao.brutos.io.ResourceLoader;
import org.brandao.brutos.io.UrlResource;

public class DefaultResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public DefaultResourceLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public DefaultResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Resource getResource(String path) {
        if (path.startsWith("classpath:")) {
            return new ClassPathResource(this.getClassloader(), path.substring("classpath:".length()));
        }
        try {
            URL url = new URL(path);
            return new UrlResource(url);
        }
        catch (MalformedURLException e) {
            return this.getContextResource(path);
        }
    }

    protected Resource getContextResource(String path) {
        throw new BrutosException("not found: " + path);
    }

    public ClassLoader getClassloader() {
        return this.classLoader;
    }
}

