/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.logger;

import java.util.Properties;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.logger.Logger;

public abstract class LoggerProvider {
    private static LoggerProvider currentLoggerProvider;

    public static LoggerProvider getProvider(Properties config) {
        String loggerName = config.getProperty("org.brandao.brutos.logger.provider", "org.brandao.brutos.logger.JavaLoggerProvider");
        LoggerProvider logger = null;
        try {
            Class<?> loggerClass = ClassUtil.get(loggerName);
            logger = (LoggerProvider)ClassUtil.getInstance(loggerClass);
        }
        catch (ClassNotFoundException e) {
            throw new BrutosException(e);
        }
        catch (InstantiationException e) {
            throw new BrutosException(e);
        }
        catch (IllegalAccessException e) {
            throw new BrutosException(e);
        }
        logger.configure(config);
        return logger;
    }

    public static LoggerProvider getCurrentLoggerProvider() {
        return currentLoggerProvider;
    }

    public static void setCurrentLoggerProvider(LoggerProvider aCurrentLoggerProvider) {
        currentLoggerProvider = aCurrentLoggerProvider;
    }

    public abstract void configure(Properties var1);

    public abstract void destroy();

    public abstract Logger getLogger(String var1);

    public abstract Logger getLogger(Class var1);

    static {
        Properties config = new Properties();
        LoggerProvider.setCurrentLoggerProvider(LoggerProvider.getProvider(config));
    }
}

