/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.DispatcherType;
import org.brandao.brutos.mapping.ActionID;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.DataTypeMap;
import org.brandao.brutos.mapping.MappingException;
import org.brandao.brutos.mapping.ParameterAction;
import org.brandao.brutos.mapping.ParameterNameResolver;
import org.brandao.brutos.mapping.ResultAction;
import org.brandao.brutos.mapping.ThrowableSafeData;
import org.brandao.brutos.type.AnyType;
import org.brandao.brutos.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action {
    private long code;
    private Controller controller;
    private ActionID id;
    private String name;
    private String simpleName;
    private List<ActionID> alias;
    private String executor;
    private List<ParameterAction> parameters = new ArrayList<ParameterAction>();
    private Map<Class<?>, ThrowableSafeData> throwsSafe;
    private Method method;
    private List<Class<?>> parametersType = new ArrayList();
    private boolean returnRendered;
    private String view;
    private boolean resolvedView;
    private ResultAction resultAction;
    private boolean redirect = false;
    private DispatcherType dispatcherType;
    private Validator parametersValidator;
    private Validator resultValidator;
    private DataTypeMap requestTypes;
    private DataTypeMap responseTypes;
    private static long counter = 1L;

    public Action() {
        this.throwsSafe = new HashMap();
        this.dispatcherType = DispatcherType.FORWARD;
        this.resultAction = new ResultAction(this);
        this.alias = new ArrayList<ActionID>();
        this.requestTypes = new DataTypeMap();
        this.responseTypes = new DataTypeMap();
    }

    public DataTypeMap getRequestTypes() {
        return this.requestTypes;
    }

    public void setRequestTypes(DataTypeMap requestTypes) {
        this.requestTypes = requestTypes;
    }

    public DataTypeMap getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(DataTypeMap responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addParameter(ParameterAction value) {
        this.parameters.add(value);
    }

    public ParameterAction getParameter(int index) {
        return this.parameters.get(index);
    }

    public void removeParameter(int index) {
        this.parameters.remove(index);
    }

    public List<ParameterAction> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterAction> parameters) {
        this.parameters = parameters;
    }

    public ThrowableSafeData getThrowsSafeOnAction(Class<?> thr) {
        return this.throwsSafe.get(thr);
    }

    public ThrowableSafeData getThrowsSafe(Class<?> thr) {
        ThrowableSafeData e = this.throwsSafe.get(thr);
        if (e == null) {
            e = this.throwsSafe.get(Throwable.class);
        }
        if (e == null) {
            e = this.controller.getThrowsSafe(thr);
        }
        return e;
    }

    public void setThrowsSafe(ThrowableSafeData thr) {
        this.throwsSafe.put(thr.getTarget(), thr);
    }

    public int getParamterSize() {
        return this.parameters.size();
    }

    public Class<?> getParameterType(int index) {
        return this.parametersType.get(index);
    }

    public Type getGenericParameterType(int index) {
        return this.method.getGenericParameterTypes()[index];
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public List<Class<?>> getParametersType() {
        return this.parametersType;
    }

    public void setParametersType(List<Class<?>> parametersType) {
        this.parametersType = parametersType;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public synchronized void flush() {
        try {
            if (this.executor == null) {
                return;
            }
            this.method = this.getMethod(this.executor, this.controller.getClassType());
            this.controller.addReserveMethod(this.method, this);
            this.setParametersType(Arrays.asList(this.method.getParameterTypes()));
            Class<?> returnClassType = this.method.getReturnType();
            if (returnClassType != Void.TYPE) {
                org.brandao.brutos.type.Type resultType = this.controller.getContext().getTypeManager().getType(returnClassType);
                if (this.resultAction.getType() != null) {
                    org.brandao.brutos.type.Type expectedType = this.resultAction.getType();
                    if (!resultType.getClassType().isAssignableFrom(expectedType.getClassType())) {
                        throw new MappingException("Invalid result type: expected " + expectedType.getClassType() + "found " + resultType);
                    }
                } else {
                    this.resultAction.setType(resultType);
                }
            }
            this.setMethod(this.method);
        }
        catch (BrutosException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    private Method getMethod(String name, Class<?> clazz) {
        int i;
        int size = this.parameters.size();
        Class[] classArgs = new Class[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ParameterAction arg = this.parameters.get(i2);
            classArgs[i2] = arg.getClassType();
        }
        for (Class<?> tmpClazz = clazz; tmpClazz != Object.class; tmpClazz = tmpClazz.getSuperclass()) {
            Method[] methods = tmpClazz.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(name) || !this.isCompatible(m, classArgs)) continue;
                Class<?>[] params = m.getParameterTypes();
                for (int k = 0; k < params.length; ++k) {
                    ParameterAction arg = this.parameters.get(k);
                    String parameterName = ParameterNameResolver.getName(m, k);
                    arg.setRealName(parameterName);
                    if (".".equals(arg.getName())) {
                        arg.setName(parameterName);
                    }
                    if (arg.getType() != null) continue;
                    if (arg.getMetaBean() != null) {
                        arg.setType(new AnyType(params[k]));
                        continue;
                    }
                    arg.setType(this.controller.getContext().getTypeManager().getType(params[k]));
                }
                return m;
            }
        }
        String msg = "not found: " + clazz.getName() + "." + name + "( ";
        for (i = 0; i < classArgs.length; ++i) {
            Class arg = classArgs[i];
            msg = msg + (i != 0 ? ", " : "");
            msg = msg + (arg == null ? "?" : arg.getName());
        }
        msg = msg + " )";
        throw new BrutosException(msg);
    }

    private boolean isCompatible(Method m, Class<?>[] classArgs) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length == classArgs.length) {
            for (int i = 0; i < params.length; ++i) {
                if (classArgs[i] == null || ClassUtil.getWrapper(params[i]).isAssignableFrom(ClassUtil.getWrapper(classArgs[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Class<?>[] getParameterClass() {
        int length = this.parameters.size();
        Class[] result = new Class[length];
        for (int i = 0; i < length; ++i) {
            ParameterAction p = this.parameters.get(i);
            result[i] = p.getClassType();
        }
        return result;
    }

    public String getExecutor() {
        return this.executor;
    }

    public void setExecutor(String value) {
        this.executor = value;
    }

    public Object invoke(Object source, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object result = null;
        if (this.method != null) {
            if (this.parametersValidator != null) {
                this.parametersValidator.validate(this, source, args);
            }
            result = this.method.invoke(source, args);
            if (this.resultValidator != null) {
                this.resultValidator.validate(this.resultAction, source, result);
            }
        }
        return result;
    }

    public boolean isAbstract() {
        return this.method == null;
    }

    public List<ActionID> getAlias() {
        return this.alias;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public ActionID getId() {
        return this.id;
    }

    public void setId(ActionID value) {
        this.id = value;
    }

    public boolean isReturnRendered() {
        return this.returnRendered;
    }

    public void setReturnRendered(boolean returnRendered) {
        this.returnRendered = returnRendered;
    }

    public boolean isResolvedView() {
        return this.resolvedView;
    }

    public void setResolvedView(boolean resolvedView) {
        this.resolvedView = resolvedView;
    }

    public Validator getParametersValidator() {
        return this.parametersValidator;
    }

    public void setParametersValidator(Validator parametersValidator) {
        this.parametersValidator = parametersValidator;
    }

    public Validator getResultValidator() {
        return this.resultValidator;
    }

    public void setResultValidator(Validator resultValidator) {
        this.resultValidator = resultValidator;
    }

    public ResultAction getResultAction() {
        return this.resultAction;
    }

    public void setResultAction(ResultAction resultAction) {
        this.resultAction = resultAction;
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public static final synchronized long getNextId() {
        return counter++;
    }
}

