/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping;

import java.util.HashMap;
import java.util.Map;
import org.brandao.brutos.bean.BeanInstance;
import org.brandao.brutos.mapping.ConstructorBean;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.PropertyBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean {
    protected Bean parent;
    protected Controller controller;
    protected String name;
    protected Class<?> classType;
    protected Map<String, PropertyBean> fields = new HashMap<String, PropertyBean>();
    protected boolean hierarchy;
    protected String separator;
    protected ConstructorBean constructor;
    protected String factory;
    protected String indexFormat;
    protected BeanInstance beanInstance;
    protected boolean isAbstract;

    public Bean(Controller controller) {
        this(controller, null);
    }

    public Bean(Controller controller, Bean parent) {
        this.controller = controller;
        this.hierarchy = true;
        this.separator = ".";
        this.indexFormat = "[$index]";
        this.parent = parent;
        this.constructor = new ConstructorBean(this);
        this.isAbstract = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public void setClassType(Class<?> classType) {
        this.classType = classType;
        this.beanInstance = classType != null ? new BeanInstance(null, classType) : null;
    }

    public Map<String, PropertyBean> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, PropertyBean> fields) {
        this.fields = fields;
    }

    public boolean isBean() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void setAbstract(boolean value) {
        this.isAbstract = value;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isHierarchy() {
        return this.hierarchy;
    }

    public void setMethodfactory(String methodFactory) {
        this.getConstructor().setMethodFactory(methodFactory);
    }

    public String getMethodfactory() {
        return this.getConstructor().getMethodFactory();
    }

    public void setHierarchy(boolean hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public ConstructorBean getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorBean constructor) {
        this.constructor = constructor;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getIndexFormat() {
        return this.indexFormat;
    }

    public void setIndexFormat(String indexFormat) {
        this.indexFormat = indexFormat;
    }

    public PropertyBean getProperty(String name) {
        return this.fields.get(name);
    }

    public BeanInstance getBeanInstance() {
        return this.beanInstance;
    }

    public void setBeanInstance(BeanInstance beanInstance) {
        this.beanInstance = beanInstance;
    }

    public Bean getParent() {
        return this.parent;
    }

    public void setParent(Bean parent) {
        this.parent = parent;
    }
}

