/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.mapping.Bean;
import org.brandao.brutos.mapping.ConstructorArgBean;
import org.brandao.brutos.mapping.ParameterNameResolver;
import org.brandao.brutos.type.AnyType;
import org.brandao.brutos.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorBean {
    private List<ConstructorArgBean> args = new ArrayList<ConstructorArgBean>();
    private Constructor<?> contructor;
    private Method method;
    private String methodFactory;
    private Bean bean;
    private Validator validator;
    private boolean collection;

    public ConstructorBean(Bean bean) {
        this.bean = bean;
        this.collection = bean.getParent() != null && bean.getParent().isCollection();
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isConstructor() {
        return this.getMethodFactory() == null;
    }

    public boolean isMethodFactory() {
        return this.getMethodFactory() != null;
    }

    public Constructor<?> getContructor() {
        this.initIfNecessary();
        return this.contructor;
    }

    private synchronized void initIfNecessary() {
        if (this.contructor == null) {
            this.setContructor(this.getContructor(this.getBean().getClassType()));
        }
    }

    public Method getMethod(Object factory) {
        if (this.getMethod() == null) {
            Class<?> clazz = factory == null ? this.getBean().getClassType() : factory.getClass();
            this.setMethod(this.getMethod(this.getMethodFactory(), clazz));
            if (this.getMethod().getReturnType() == Void.TYPE) {
                throw new BrutosException("invalid return: " + this.getMethod().toString());
            }
        }
        return this.getMethod();
    }

    public void addConstructorArg(ConstructorArgBean arg) {
        this.args.add(arg);
    }

    public ConstructorArgBean getConstructorArg(int index) {
        return this.args.get(index);
    }

    public List<ConstructorArgBean> getConstructorArgs() {
        return this.args;
    }

    public int size() {
        return this.args.size();
    }

    private Constructor<?> getContructor(Class<?> clazz) {
        int size = this.size();
        Class[] classArgs = new Class[size];
        for (int i = 0; i < size; ++i) {
            ConstructorArgBean arg = this.getConstructorArg(i);
            classArgs[i] = arg.getClassType();
        }
        Constructor<?>[] cons = clazz.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> con = cons[i];
            if (!this.isCompatible(con, classArgs)) continue;
            Class<?>[] params = con.getParameterTypes();
            for (int k = 0; k < params.length; ++k) {
                ConstructorArgBean arg = this.getConstructorArg(k);
                String parameterName = ParameterNameResolver.getName(con, k);
                arg.setRealName(parameterName);
                if (".".equals(arg.getParameterName())) {
                    arg.setParameterName(parameterName);
                }
                if (this.getConstructorArg(k).getType() != null) continue;
                ConstructorArgBean argBean = this.getConstructorArg(k);
                if (argBean.getMetaBean() != null) {
                    argBean.setType(new AnyType(params[k]));
                    continue;
                }
                argBean.setType(this.getBean().getController().getContext().getTypeManager().getType(params[k], argBean.getEnumProperty(), argBean.getTemporalType()));
            }
            return con;
        }
        String msg = "not found: " + clazz.getName() + "( ";
        for (int i = 0; i < classArgs.length; ++i) {
            Class arg = classArgs[i];
            msg = msg + (i != 0 ? ", " : "");
            msg = msg + (arg == null ? "?" : arg.getName());
        }
        msg = msg + " )";
        throw new BrutosException(msg);
    }

    private Method getMethod(String name, Class<?> clazz) {
        int i;
        int size = this.size();
        Class[] classArgs = new Class[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ConstructorArgBean arg = this.getConstructorArg(i2);
            classArgs[i2] = arg.getClassType();
        }
        for (Class<?> tmpClazz = clazz; tmpClazz != Object.class; tmpClazz = tmpClazz.getSuperclass()) {
            Method[] methods = tmpClazz.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getName().equals(name) || !this.isCompatible(m, classArgs)) continue;
                Class<?>[] params = m.getParameterTypes();
                for (int k = 0; k < params.length; ++k) {
                    if (this.getConstructorArg(k).getType() != null) continue;
                    this.getConstructorArg(k).setType(this.getBean().getController().getContext().getTypeManager().getType(params[k]));
                }
                return m;
            }
        }
        String msg = "not found: " + clazz.getName() + "." + name + "( ";
        for (i = 0; i < classArgs.length; ++i) {
            Class arg = classArgs[i];
            msg = msg + (i != 0 ? ", " : "");
            msg = msg + (arg == null ? "?" : arg.getName());
        }
        msg = msg + " )";
        throw new BrutosException(msg);
    }

    private boolean isCompatible(Constructor<?> m, Class<?>[] classArgs) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length == classArgs.length) {
            for (int i = 0; i < params.length; ++i) {
                if (classArgs[i] == null || params[i].isAssignableFrom(classArgs[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isCompatible(Method m, Class<?>[] classArgs) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length == classArgs.length) {
            for (int i = 0; i < params.length; ++i) {
                if (classArgs[i] == null || ClassUtil.getWrapper(params[i]).isAssignableFrom(ClassUtil.getWrapper(classArgs[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setContructor(Constructor<?> contructor) {
        this.contructor = contructor;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getMethodFactory() {
        return this.methodFactory;
    }

    public void setMethodFactory(String methodFactory) {
        this.methodFactory = methodFactory;
    }

    public Bean getBean() {
        return this.bean;
    }

    public void setBean(Bean bean) {
        this.bean = bean;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

