/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.brandao.brutos.ActionType;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ConfigurableApplicationContext;
import org.brandao.brutos.DispatcherType;
import org.brandao.brutos.Invoker;
import org.brandao.brutos.ObjectFactory;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.Scopes;
import org.brandao.brutos.bean.BeanInstance;
import org.brandao.brutos.interceptor.InterceptorHandler;
import org.brandao.brutos.interceptor.InterceptorProcess;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.mapping.ActionID;
import org.brandao.brutos.mapping.ActionListener;
import org.brandao.brutos.mapping.Bean;
import org.brandao.brutos.mapping.ControllerID;
import org.brandao.brutos.mapping.DataTypeMap;
import org.brandao.brutos.mapping.Interceptor;
import org.brandao.brutos.mapping.InvokeException;
import org.brandao.brutos.mapping.PropertyController;
import org.brandao.brutos.mapping.ReverseActionKey;
import org.brandao.brutos.mapping.ThrowableSafeData;
import org.brandao.brutos.scope.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private String name;
    private ControllerID id;
    private Class<?> classType;
    private String actionId;
    private Map<String, Bean> mappingBeans;
    private List<PropertyController> fields = new ArrayList<PropertyController>();
    private Map<ActionID, Action> actions;
    private Map<ReverseActionKey, List<Action>> reverseMethods;
    private ActionListener actionListener;
    private Map<Class<?>, ThrowableSafeData> throwsSafe;
    private List<ControllerID> alias;
    private ScopeType scope;
    private String view;
    private boolean redirect = false;
    private ActionID defaultAction;
    private List<Interceptor> interceptorStack;
    private InterceptorProcess interceptorProcess;
    private DispatcherType dispatcherType;
    private List<Interceptor> defaultInterceptorList;
    private ActionType actionType;
    private boolean resolvedView;
    private ConfigurableApplicationContext context;
    private BeanInstance beanInstance;
    private DataTypeMap requestTypes;
    private DataTypeMap responseTypes;

    public Controller(ConfigurableApplicationContext context) {
        this.mappingBeans = new LinkedHashMap<String, Bean>();
        this.actions = new LinkedHashMap<ActionID, Action>();
        this.interceptorStack = new ArrayList<Interceptor>();
        this.alias = new ArrayList<ControllerID>();
        this.reverseMethods = new LinkedHashMap<ReverseActionKey, List<Action>>();
        this.interceptorProcess = new InterceptorProcess();
        this.scope = ScopeType.PARAM;
        this.actionType = ActionType.PARAMETER;
        this.context = context;
        this.requestTypes = new DataTypeMap();
        this.responseTypes = new DataTypeMap();
        this.throwsSafe = new HashMap();
        this.interceptorProcess.setForm(this);
    }

    public DataTypeMap getRequestTypes() {
        return this.requestTypes;
    }

    public void setRequestTypes(DataTypeMap requestTypes) {
        this.requestTypes = requestTypes;
    }

    public DataTypeMap getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(DataTypeMap responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String getActionId() {
        return this.actionId;
    }

    public Object getInstance(ObjectFactory objectFactory) {
        Object instance = this.name == null ? null : objectFactory.getBean(this.name);
        Object object = instance = instance == null ? objectFactory.getBean(this.classType) : instance;
        if (instance == null) {
            throw new BrutosException("can't get instance " + this.name + ":" + this.classType);
        }
        return instance;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Bean getBean(String name) {
        return this.mappingBeans.get(name);
    }

    public Map<String, Bean> getBeans() {
        return this.mappingBeans;
    }

    public void addBean(String name, Bean bean) {
        this.mappingBeans.put(name, bean);
    }

    public boolean containsProperty(String name) {
        return this.getProperty(name) != null;
    }

    public PropertyController getProperty(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getPropertyName().equals(name)) continue;
            return this.fields.get(i);
        }
        return null;
    }

    public List<PropertyController> getProperties() {
        return this.fields;
    }

    public void addProperty(PropertyController property) {
        if (!this.containsProperty(property.getPropertyName())) {
            this.fields.add(property);
        }
    }

    public ActionListener getAcion() {
        return this.getActionListener();
    }

    public void setAcion(ActionListener acion) {
        this.setActionListener(acion);
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public void setClassType(Class<?> classType) {
        this.classType = classType;
        this.beanInstance = new BeanInstance(null, classType);
    }

    public Action getActionById(ActionID id) {
        return this.actions.get(id);
    }

    public Action getActionByName(String name) {
        return this.actions.get(new ActionID(name));
    }

    public Map<ActionID, Action> getActions() {
        return this.actions;
    }

    public void addAction(ActionID id, Action method) {
        this.actions.put(id, method);
        this.context.getActionResolver().registry(null, method.getController(), id, method);
    }

    public void removeAction(ActionID id) {
        Action method = this.actions.get(id);
        if (method == null) {
            return;
        }
        if (id.equals(method.getId())) {
            this.actions.remove(id);
            for (ActionID alias : method.getAlias()) {
                this.actions.remove(alias);
            }
            this.context.getActionResolver().remove(null, method.getController(), null, method);
        } else {
            this.actions.remove(id);
            this.context.getActionResolver().remove(null, method.getController(), id, method);
        }
    }

    Map<ReverseActionKey, List<Action>> getReverseMethods() {
        return this.reverseMethods;
    }

    void addReserveMethod(Method method, Action action) {
        ReverseActionKey key = new ReverseActionKey(method);
        List<Action> list = this.reverseMethods.get(key);
        if (list == null) {
            list = new LinkedList<Action>();
            this.reverseMethods.put(key, list);
        }
        list.add(action);
    }

    public Action getMethod(Method method) {
        ReverseActionKey key = new ReverseActionKey(method);
        List<Action> list = this.reverseMethods.get(key);
        if (list == null) {
            return null;
        }
        if (list.size() > 1) {
            throw new BrutosException(String.format("Ambiguous reference to action: %s", method.getName()));
        }
        return list.get(0);
    }

    public void setMethods(Map<ActionID, Action> methods) {
        this.actions = methods;
    }

    public void addInterceptor(Interceptor interceptor) {
        this.addInterceptor(new Interceptor[]{interceptor});
    }

    public void addInterceptor(Interceptor[] interceptor) {
        for (Interceptor i : interceptor) {
            if (this.interceptorStack.contains(i)) {
                throw new BrutosException(i.getName() + " already associated with the controller");
            }
            this.interceptorStack.add(i);
        }
    }

    public void removeInterceptor(Interceptor interceptor) {
        this.removeInterceptor(new Interceptor[]{interceptor});
    }

    public void removeInterceptor(Interceptor[] interceptor) {
        for (Interceptor i : interceptor) {
            if (!this.interceptorStack.contains(i)) {
                throw new BrutosException("interceptor not found: " + i.getName());
            }
            this.interceptorStack.remove(i);
        }
    }

    public boolean isInterceptedBy(Interceptor interceptor) {
        return this.interceptorStack.contains(interceptor);
    }

    public List<Interceptor> getInterceptors() {
        return this.getInterceptorStack();
    }

    public Object getInstance() {
        try {
            return this.getClassType().newInstance();
        }
        catch (Exception e) {
            throw new InvokeException(e);
        }
    }

    public Action getAction(ActionID value) {
        Action mf = this.name == null ? null : this.actions.get(value);
        mf = mf == null ? this.actions.get(this.getDefaultAction()) : mf;
        return mf;
    }

    public void proccessBrutosAction(InterceptorHandler handler) {
        this.interceptorProcess.process(handler);
    }

    public synchronized void flush() {
        this.interceptorProcess.flush();
        for (Action ac : this.actions.values()) {
            ac.flush();
        }
    }

    public void fieldsToRequest(Object webFrame) {
        try {
            Scopes scopes = Invoker.getCurrentApplicationContext().getScopes();
            Field[] fields = this.getClassType().getDeclaredFields();
            Scope scope = scopes.get(ScopeType.REQUEST);
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                f.setAccessible(true);
                scope.put(f.getName(), f.get(webFrame));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ThrowableSafeData getThrowsSafe(Class<?> thr) {
        ThrowableSafeData e = this.throwsSafe.get(thr);
        if (e == null) {
            e = this.throwsSafe.get(Throwable.class);
        }
        return e;
    }

    public void removeThrowsSafe(Class<?> thr) {
        this.throwsSafe.remove(thr);
    }

    public void setThrowsSafe(ThrowableSafeData thr) {
        this.throwsSafe.put(thr.getTarget(), thr);
    }

    public List<ControllerID> getAlias() {
        return this.alias;
    }

    public ScopeType getScope() {
        return this.scope;
    }

    public void setScope(ScopeType scope) {
        this.scope = scope;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view = view == null || view.trim().length() == 0 ? null : view;
    }

    public ActionID getDefaultAction() {
        return this.defaultAction;
    }

    public void setDefaultAction(ActionID defaultAction) {
        this.defaultAction = defaultAction;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ControllerID getId() {
        return this.id;
    }

    public void setId(ControllerID id) {
        this.id = id;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener action) {
        this.actionListener = action;
    }

    public List<Interceptor> getInterceptorStack() {
        return this.interceptorStack;
    }

    public void setInterceptorStack(List<Interceptor> interceptorStack) {
        this.interceptorStack = interceptorStack;
    }

    public InterceptorProcess getInterceptorProcess() {
        return this.interceptorProcess;
    }

    public void setInterceptorProcess(InterceptorProcess interceptorProcess) {
        this.interceptorProcess = interceptorProcess;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public List<Interceptor> getDefaultInterceptorList() {
        return this.defaultInterceptorList;
    }

    public void setDefaultInterceptorList(List<Interceptor> defaultInterceptorList) {
        this.defaultInterceptorList = defaultInterceptorList;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(ActionType actionType) {
        this.actionType = actionType;
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public void setContext(ConfigurableApplicationContext context) {
        this.context = context;
    }

    public boolean isResolvedView() {
        return this.resolvedView;
    }

    public void setResolvedView(boolean resolvedView) {
        this.resolvedView = resolvedView;
    }

    public BeanInstance getBeanInstance() {
        return this.beanInstance;
    }

    public void setBeanInstance(BeanInstance beanInstance) {
        this.beanInstance = beanInstance;
    }
}

