/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeMap {
    private Map<String, DataType> map = new HashMap<String, DataType>();
    private Set<DataType> set;
    private Set<DataType> publicSet;
    private DataType defaultDataType;

    public DataTypeMap() {
        this.set = new HashSet<DataType>();
        this.publicSet = Collections.unmodifiableSet(this.set);
    }

    public DataType getDefaultDataType() {
        return this.defaultDataType;
    }

    public void setDefaultDataType(DataType defaultDataType) {
        this.defaultDataType = defaultDataType;
    }

    public DataTypeMap(Set<DataType> value) {
        for (DataType v : value) {
            this.add(v);
        }
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public void clear() {
        this.set.clear();
        this.map.clear();
    }

    public void add(DataType value) {
        if (this.set.contains(value)) {
            throw new BrutosException("type has been added: " + value.getName());
        }
        this.map.put(value.getName(), value);
        this.set.add(value);
    }

    public void remove(DataType value) {
        if (!this.set.contains(value.getName())) {
            throw new BrutosException("subtype not found: " + value.getName());
        }
        this.map.remove(value);
        this.set.add(value);
    }

    public boolean accept(DataType value) {
        return value != null && this.map.containsKey(value.getName());
    }

    public DataType accept(DataTypeMap map) {
        Set<DataType> types = map.set;
        for (DataType type : types) {
            if (!this.accept(type)) continue;
            return type;
        }
        return null;
    }

    public boolean contains(DataType value) {
        return this.map.containsKey(value.getName());
    }

    public Set<DataType> getSet() {
        return this.publicSet;
    }
}

