/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping;

import java.util.Map;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interceptor {
    private String name;
    private Class<?> type;
    private Map<String, Object> properties;
    boolean def;
    private Interceptor parent;

    public Interceptor(Interceptor parent) {
        this.parent = parent;
    }

    public Interceptor() {
    }

    public Object getInstance(ObjectFactory objectFactory) {
        Object instance = this.getName() == null ? null : objectFactory.getBean(this.getName());
        Object object = instance = instance == null ? objectFactory.getBean(this.getType()) : instance;
        if (instance == null) {
            throw new BrutosException("can't get instance " + this.getName() + ":" + this.getType());
        }
        return instance;
    }

    public String getName() {
        return this.parent == null ? this.name : this.parent.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getType() {
        return this.parent == null ? this.type : this.parent.getType();
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String name, Object value) {
        this.checkProperty(name, this);
        this.properties.put(name, value);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Object getProperty(String name) {
        Object value = this.properties.get(name);
        value = value == null && this.parent != null ? this.parent.getProperty(name) : value;
        return value;
    }

    public void setDefault(boolean value) {
        this.def = value;
    }

    public boolean isDefault() {
        return this.parent == null ? this.def : this.parent.isDefault();
    }

    protected void checkProperty(String name, Interceptor stack) {
        if (name == null) {
            throw new BrutosException("parameter name must be informed");
        }
        if (!name.matches("([a-zA-Z0-9_]+)")) {
            throw new BrutosException("invalid parameter name: " + name);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interceptor other = (Interceptor)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }
}

