/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping;

import java.util.HashMap;
import java.util.Map;
import org.brandao.brutos.ScopeType;
import org.brandao.brutos.Scopes;
import org.brandao.brutos.mapping.Bean;
import org.brandao.brutos.mapping.Controller;
import org.brandao.brutos.mapping.DependencyBean;
import org.brandao.brutos.mapping.MappingException;
import org.brandao.brutos.scope.Scope;
import org.brandao.brutos.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaBean
extends Bean {
    private Map<Object, DependencyBean> metaValues = new HashMap<Object, DependencyBean>();
    private Type type;
    private ScopeType scopeType;

    public MetaBean(Controller controller) {
        super(controller);
    }

    public void putMetaValue(String value, DependencyBean bean) {
        Object metaValue = this.type.convert(value);
        if (metaValue == null) {
            throw new MappingException("invalid meta value: " + value);
        }
        this.putMetaValue(metaValue, bean);
    }

    public void putMetaValue(Object value, DependencyBean bean) {
        if (this.metaValues.put(value, bean) != null) {
            throw new MappingException("duplicate meta value: " + value);
        }
    }

    public void removeMetaValue(Object value) {
        this.metaValues.remove(value);
    }

    public void removeMetaValue(String value) {
        Object metaValue = this.type.convert(value);
        this.metaValues.remove(metaValue);
    }

    public Map<Object, DependencyBean> getMetaValues() {
        return this.metaValues;
    }

    public Scope getScope() {
        return Scopes.getCurrentScope(this.scopeType);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public ScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(ScopeType scopeType) {
        this.scopeType = scopeType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.metaValues.size();
    }
}

