/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.mapping.MappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterNameResolver {
    private static Method getParametersNameMethodByMethod;
    private static Method getParametersNameMethodByCosntructor;
    private static Method getName;

    private static void loadParametersNameMethodByMethod() {
        try {
            getParametersNameMethodByMethod = Method.class.getMethod("getParameters", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getParametersNameMethodByMethod = null;
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static void loadParametersNameMethodByconstructor() {
        try {
            getParametersNameMethodByCosntructor = Constructor.class.getMethod("getParameters", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getParametersNameMethodByCosntructor = null;
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static void loadGetNameMethod() {
        try {
            Class<?> clazz = ClassUtil.get("java.lang.reflect.Parameter");
            getName = clazz.getMethod("getName", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            getName = null;
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static String getName(Method origin, int index) {
        try {
            if (getParametersNameMethodByMethod == null) {
                return "arg" + index;
            }
            Object parameters = ParameterNameResolver.getParameters(origin);
            Object parameter = ParameterNameResolver.getItem(parameters, index);
            return (String)ParameterNameResolver.getParameterName(parameter);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
        catch (Throwable e) {
            throw new MappingException(e);
        }
    }

    public static String getName(Constructor<?> origin, int index) {
        try {
            if (getParametersNameMethodByCosntructor == null) {
                return "arg" + index;
            }
            Object parameters = ParameterNameResolver.getParameters(origin);
            Object parameter = ParameterNameResolver.getItem(parameters, index);
            return (String)ParameterNameResolver.getParameterName(parameter);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
        catch (Throwable e) {
            throw new MappingException(e);
        }
    }

    private static Object getParameters(Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return getParametersNameMethodByMethod.invoke((Object)method, new Object[0]);
    }

    private static Object getParameters(Constructor<?> constructor) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return getParametersNameMethodByCosntructor.invoke(constructor, new Object[0]);
    }

    private static Object getItem(Object list, int index) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return Array.get(list, index);
    }

    private static Object getParameterName(Object parameter) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (String)getName.invoke(parameter, new Object[0]);
    }

    static {
        ParameterNameResolver.loadParametersNameMethodByMethod();
        ParameterNameResolver.loadParametersNameMethodByconstructor();
        ParameterNameResolver.loadGetNameMethod();
    }
}

