/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.mapping.ioc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.mapping.ioc.Injectable;

public class ConstructorInject {
    private List args;
    private Constructor contructor;
    private Method method;
    private String methodFactory;
    private Injectable inject;

    public ConstructorInject(Injectable inject) {
        this.args = new ArrayList();
        this.inject = inject;
    }

    public ConstructorInject(Constructor constructor, Injectable[] args) {
        this.contructor = constructor;
        this.args = args.length == 0 ? new ArrayList() : Arrays.asList(args);
    }

    public void setMethodFactory(String method) {
        this.methodFactory = method;
    }

    public String getMethodFactory() {
        return this.methodFactory;
    }

    public void addArg(Injectable arg) {
        this.args.add(arg);
    }

    public void removeArg(Injectable arg) {
        this.args.remove(arg);
    }

    public Injectable getArg(int index) {
        return (Injectable)this.args.get(index);
    }

    public int length() {
        return this.args.size();
    }

    public List getArgs() {
        return this.args;
    }

    public void setArgs(List args) {
        this.args = args;
    }

    public boolean isConstructor() {
        return this.methodFactory == null;
    }

    public boolean isMethodFactory() {
        return this.methodFactory != null;
    }

    public Constructor getContructor() {
        if (this.contructor == null) {
            this.contructor = this.getContructor(this.inject.getTarget());
        }
        return this.contructor;
    }

    public void setContructor(Constructor contructor) {
        this.contructor = contructor;
    }

    public Method getMethod(Object factory) {
        if (this.method == null) {
            Class clazz = factory == null ? this.inject.getTarget() : factory.getClass();
            this.method = this.getMethod(this.methodFactory, clazz);
            if (this.method.getReturnType() == Void.TYPE) {
                throw new BrutosException("invalid return: " + this.method.toString());
            }
        }
        return this.method;
    }

    private Constructor getContructor(Class clazz) {
        Class[] classArgs = new Class[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            Injectable arg = (Injectable)this.args.get(i);
            if (arg.getTarget() == null) continue;
            classArgs[i] = arg.getTarget();
        }
        Constructor<?>[] cons = clazz.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> con = cons[i];
            if (!this.isCompatible(con, classArgs)) continue;
            return con;
        }
        String msg = "not found: " + clazz.getName() + "( ";
        for (int i = 0; i < classArgs.length; ++i) {
            Class arg = classArgs[i];
            msg = msg + (i != 0 ? ", " : "");
            msg = msg + (arg == null ? "?" : arg.getName());
        }
        msg = msg + " )";
        throw new BrutosException(msg);
    }

    private Method getMethod(String name, Class clazz) {
        Class[] classArgs = new Class[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            Injectable arg = (Injectable)this.args.get(i);
            if (arg.getTarget() == null) continue;
            classArgs[i] = arg.getTarget();
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(name) || !this.isCompatible(m, classArgs)) continue;
            return m;
        }
        String msg = "not found: " + clazz.getName() + "( ";
        for (int i = 0; i < classArgs.length; ++i) {
            Class arg = classArgs[i];
            msg = msg + (i != 0 ? ", " : "");
            msg = msg + (arg == null ? "?" : arg.getName());
        }
        msg = msg + " )";
        throw new BrutosException(msg);
    }

    private boolean isCompatible(Constructor m, Class[] classArgs) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length == classArgs.length) {
            for (int i = 0; i < params.length; ++i) {
                if (classArgs[i] == null || params[i].isAssignableFrom(classArgs[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isCompatible(Method m, Class[] classArgs) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length == classArgs.length) {
            for (int i = 0; i < params.length; ++i) {
                if (classArgs[i] == null || ClassUtil.getWrapper(params[i]).isAssignableFrom(ClassUtil.getWrapper(classArgs[i]))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

