/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.proxy;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.FetchType;
import org.brandao.brutos.mapping.BeanDecoder;
import org.brandao.brutos.mapping.BeanDecoderException;
import org.brandao.brutos.mapping.DependencyBean;
import org.brandao.brutos.mapping.UseBeanData;
import org.brandao.brutos.proxy.AbstractEntityProxyHandler;
import org.brandao.brutos.proxy.LazyLoadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanEntityProxyHandler
extends AbstractEntityProxyHandler {
    private Object metadata;
    private Object data;
    private volatile Object value;
    private BeanDecoder decoder;

    public BeanEntityProxyHandler(Object metadata, Object data, BeanDecoder decoder) {
        this.metadata = metadata;
        this.decoder = decoder;
        this.value = null;
        this.data = data;
        this.target = null;
    }

    @Override
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        try {
            if (super.isGetEntityProxyHandlerMethod(thisMethod)) {
                return this;
            }
            if (this.value == null) {
                this.load();
            }
            if (this.value == null) {
                throw new LazyLoadException("can't load entity");
            }
            return thisMethod.invoke(this.value, args);
        }
        catch (LazyLoadException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new LazyLoadException(e);
        }
    }

    @Override
    public Object getTarget() {
        try {
            if (this.value == null) {
                this.load();
            }
            return super.getTarget();
        }
        catch (LazyLoadException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new LazyLoadException(e);
        }
    }

    private synchronized void load() throws BeanDecoderException, InstantiationException, IllegalAccessException {
        if (this.value != null) {
            return;
        }
        if (this.metadata instanceof UseBeanData) {
            UseBeanData m = (UseBeanData)this.metadata;
            this.value = this.decoder.decode(m, FetchType.EAGER, this.data);
            if (this.value == null) {
                this.value = this.getDefaultInstance(m.getClassType());
            }
        } else if (this.metadata instanceof DependencyBean) {
            DependencyBean m = (DependencyBean)this.metadata;
            this.value = this.decoder.decode(m, FetchType.EAGER, this.data);
            if (this.value == null) {
                this.value = this.getDefaultInstance(m.getClassType());
            }
        } else {
            throw new IllegalStateException(String.valueOf(this.metadata));
        }
        this.target = this.value;
    }

    private Object getDefaultInstance(Class<?> type) throws InstantiationException, IllegalAccessException {
        if (List.class.isAssignableFrom(type)) {
            return ClassUtil.getInstance(ClassUtil.getInstantiableClass(List.class));
        }
        if (Set.class.isAssignableFrom(type)) {
            return ClassUtil.getInstance(ClassUtil.getInstantiableClass(Set.class));
        }
        if (Map.class.isAssignableFrom(type)) {
            return ClassUtil.getInstance(ClassUtil.getInstantiableClass(Map.class));
        }
        if (ConcurrentMap.class.isAssignableFrom(type)) {
            return ClassUtil.getInstance(ClassUtil.getInstantiableClass(ConcurrentMap.class));
        }
        return null;
    }
}

