/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.scanner.vfs;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.brandao.brutos.scanner.vfs.Dir;
import org.brandao.brutos.scanner.vfs.File;
import org.brandao.brutos.scanner.vfs.VfsException;

public class SystemFile
implements File {
    private Dir path;
    private java.io.File file;

    public SystemFile(Dir path, java.io.File file) {
        this.path = path;
        this.file = file;
    }

    public String getRelativePath() {
        String rootPath;
        String relativePath = this.file.getPath().replace("\\", "/").replaceAll("/+", "/");
        if (relativePath.startsWith(rootPath = this.path.getPath())) {
            return relativePath.substring(rootPath.length() + 1);
        }
        throw new VfsException();
    }

    public String getName() {
        return this.file.getName();
    }

    public InputStream openInputStream() throws VfsException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            throw new VfsException(ex);
        }
    }
}

