/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.scanner.vfs;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.brandao.brutos.mapping.StringUtil;
import org.brandao.brutos.scanner.vfs.Dir;
import org.brandao.brutos.scanner.vfs.JarFileURLType;
import org.brandao.brutos.scanner.vfs.JarURLType;
import org.brandao.brutos.scanner.vfs.JbossVFSURLType;
import org.brandao.brutos.scanner.vfs.SystemURLType;
import org.brandao.brutos.scanner.vfs.URLType;
import org.brandao.brutos.scanner.vfs.VfsException;

public final class Vfs {
    public static final List DefaultURLTypes = new ArrayList();

    public static Dir getDir(URL url) {
        return Vfs.getDir(url, DefaultURLTypes);
    }

    public static Dir getDir(URL url, List types) {
        try {
            for (int i = 0; i < DefaultURLTypes.size(); ++i) {
                URLType type = (URLType)DefaultURLTypes.get(i);
                if (!type.matches(url)) continue;
                return type.toDir(url);
            }
            throw new VfsException("invalid type: " + url);
        }
        catch (VfsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VfsException(e);
        }
    }

    public static File toFile(URL url) {
        String path = Vfs.cleanPath(url);
        File file = new File(path);
        return file.exists() ? file : null;
    }

    public static String cleanPath(URL url) {
        String path = url.getPath();
        try {
            path = path.replace("%20", " ");
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (path.startsWith("jar:")) {
            path = path.substring("jar:".length());
        }
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (path.contains(".jar!")) {
            path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
        }
        return path;
    }

    public static String getRelativePath(URL url) {
        String path = url.getPath();
        int index = path.indexOf("!");
        if (index != -1) {
            path = (path = path.substring(index + 1)).startsWith("/") ? path.substring(1) : path;
            return StringUtil.isEmpty(path) ? null : path;
        }
        return null;
    }

    public static String toClass(String resource) {
        return resource.replaceAll("/+", ".").replaceAll("\\+", ".").replaceAll(".class$", "").replaceAll("^\\.", "");
    }

    public static String toResource(String value) {
        return value.replaceAll("\\.+", "/").replaceAll("\\\\+", "/").replaceAll("/+", "/").replaceAll("^\\/", "");
    }

    static {
        DefaultURLTypes.add(new JarFileURLType());
        DefaultURLTypes.add(new JarURLType());
        DefaultURLTypes.add(new SystemURLType());
        try {
            DefaultURLTypes.add(new JbossVFSURLType());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

