/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.scanner.vfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.brandao.brutos.scanner.vfs.CloseableDir;
import org.brandao.brutos.scanner.vfs.File;
import org.brandao.brutos.scanner.vfs.ZipFile;

public class ZipDir
implements CloseableDir {
    private java.util.zip.ZipFile file;
    private String prefix;

    public ZipDir(String prefix, JarFile file) {
        this.file = file;
        this.prefix = prefix;
    }

    public String getPrefixPath() {
        return this.prefix;
    }

    public void close() throws IOException {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File[] getFiles() {
        ArrayList<ZipFile> result = new ArrayList<ZipFile>();
        Enumeration<? extends ZipEntry> entries = this.file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || this.prefix != null && !entry.getName().startsWith(this.prefix)) continue;
            result.add(new ZipFile(this, entry));
        }
        File[] files = new File[result.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = (File)result.get(i);
        }
        return files;
    }

    public String getPath() {
        return this.file.getName();
    }

    public java.util.zip.ZipFile getZipFile() {
        return this.file;
    }
}

