/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.scanner.vfs;

import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.brandao.brutos.scanner.vfs.File;
import org.brandao.brutos.scanner.vfs.VfsException;
import org.brandao.brutos.scanner.vfs.ZipDir;

public class ZipFile
implements File {
    private final ZipDir root;
    private final ZipEntry entry;

    public ZipFile(ZipDir root, ZipEntry entry) {
        this.root = root;
        this.entry = entry;
    }

    public String getRelativePath() {
        if (this.root.getPrefixPath() != null) {
            return this.entry.getName().substring(this.root.getPrefixPath().length());
        }
        return this.entry.getName();
    }

    public String getName() {
        String tmp = this.entry.getName();
        return tmp.substring(tmp.lastIndexOf("/") + 1);
    }

    public InputStream openInputStream() throws VfsException {
        try {
            return this.root.getZipFile().getInputStream(this.entry);
        }
        catch (Exception e) {
            throw new VfsException(e);
        }
    }
}

