/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.scope;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.brandao.brutos.scope.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadScope
implements Scope {
    private static final ThreadLocal<ConcurrentMap<String, Object>> threadLocal = new ThreadLocal();

    public static boolean create() {
        if (threadLocal.get() == null) {
            threadLocal.set(new ConcurrentHashMap());
            return true;
        }
        return false;
    }

    public static void destroy() {
        threadLocal.remove();
    }

    @Override
    public void put(String name, Object value) {
        ConcurrentMap<String, Object> map = threadLocal.get();
        map.put(name, value);
    }

    @Override
    public Object get(String name) {
        ConcurrentMap<String, Object> map = threadLocal.get();
        return map.get(name);
    }

    @Override
    public Object getCollection(String name) {
        return this.get(name);
    }

    @Override
    public void remove(String name) {
        ConcurrentMap<String, Object> map = threadLocal.get();
        map.remove(name);
    }

    @Override
    public List<String> getNamesStartsWith(String value) {
        ConcurrentMap<String, Object> map = threadLocal.get();
        ArrayList<String> result = new ArrayList<String>();
        for (String k : map.keySet()) {
            if (!k.startsWith(value)) continue;
            result.add(k);
        }
        return result;
    }
}

