/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.spring;

import java.util.Properties;
import org.brandao.brutos.ObjectFactory;
import org.brandao.brutos.spring.SpringContext;
import org.springframework.context.ApplicationContext;

public class SpringObjectFactory
implements ObjectFactory {
    private String name;
    private boolean initialized = false;
    private ApplicationContext context;

    public Object getBean(String name) {
        if (!this.initialized) {
            this.init();
        }
        return this.context.containsBeanDefinition(name) ? this.context.getBean(name) : null;
    }

    public Object getBean(Class clazz) {
        if (!this.initialized) {
            this.init();
        }
        return this.context.getBean(clazz);
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.context = SpringContext.getApplicationContext(this.name);
        this.initialized = true;
    }

    public void configure(Properties properties) {
        this.name = properties.getProperty("org.brandao.brutos.spring.context_name", "DEFAULT_SPRING_CONTEXT");
    }

    public void destroy() {
    }
}

