/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.type;

import java.util.Collection;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.MvcResponse;
import org.brandao.brutos.type.AbstractType;
import org.brandao.brutos.type.AnyType;
import org.brandao.brutos.type.CollectionType;
import org.brandao.brutos.type.Type;
import org.brandao.brutos.web.http.ParameterList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionType
extends AbstractType
implements CollectionType {
    private Type collectionType;
    private Class<?> rawClass;
    private Object[] parameters;

    @Override
    public void setCollectionType(Type type) {
        this.collectionType = type;
    }

    @Override
    public Type getCollectionType() {
        return this.collectionType;
    }

    @Override
    public void setRawClass(Class<?> value) {
        this.rawClass = value;
    }

    @Override
    public Class<?> getRawClass() {
        return this.rawClass;
    }

    @Override
    public void setParameters(Object[] value) {
        this.parameters = value;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof ParameterList) {
            return this.getCollection(value);
        }
        return value;
    }

    @Override
    public void show(MvcResponse response, Object value) {
        response.process(value);
    }

    protected abstract Class<?> getCollectionClass();

    protected Collection<?> getCollection(Object value) {
        try {
            Collection collection = (Collection)ClassUtil.getInstance(this.getCollectionClass());
            ParameterList list = (ParameterList)value;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object o = list.get(i);
                collection.add(this.collectionType.convert(o));
            }
            return collection;
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }

    @Override
    public String toString(Object value) {
        try {
            Collection collection = (Collection)value;
            int i = 0;
            StringBuilder r = new StringBuilder("[ ");
            for (Object o : collection) {
                if (i++ > 0) {
                    r.append(", ");
                }
                String str = this.collectionType.toString(o);
                if (this.collectionType.getClassType() == String.class || this.collectionType.getClass() == AnyType.class) {
                    r.append("\"").append(str).append("\"");
                    continue;
                }
                r.append(str);
            }
            r.append(" ]");
            return r.toString();
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }
}

