/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.type;

import java.lang.reflect.Array;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.MvcResponse;
import org.brandao.brutos.type.AbstractType;
import org.brandao.brutos.type.AnyType;
import org.brandao.brutos.type.ArrayType;
import org.brandao.brutos.type.Type;
import org.brandao.brutos.web.http.ParameterList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArrayType
extends AbstractType
implements ArrayType {
    private Type componentType;
    private Class<?> rawClass;

    private Object getArray(Object value) {
        try {
            ParameterList param = (ParameterList)value;
            Object objList = Array.newInstance(this.componentType.getClassType(), param.size());
            for (int i = 0; i < param.size(); ++i) {
                Array.set(objList, i, this.componentType.convert(param.get(i)));
            }
            return objList;
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof ParameterList) {
            return this.getArray(value);
        }
        return value;
    }

    @Override
    public void show(MvcResponse response, Object value) {
        response.process(value);
    }

    @Override
    public void setComponentType(Type type) {
        this.componentType = type;
    }

    @Override
    public Type getComponentType() {
        return this.componentType;
    }

    @Override
    public void setRawClass(Class<?> value) {
        this.rawClass = value;
    }

    @Override
    public Class<?> getRawClass() {
        return this.rawClass;
    }

    @Override
    public String toString(Object value) {
        try {
            ParameterList list = (ParameterList)value;
            int i = 0;
            StringBuilder r = new StringBuilder("[ ");
            for (Object o : list) {
                if (i++ > 0) {
                    r.append(", ");
                }
                String str = this.componentType.toString(o);
                if (this.componentType.getClassType() == String.class || this.componentType.getClass() == AnyType.class) {
                    r.append("\"").append(str).append("\"");
                    continue;
                }
                r.append(str);
            }
            r.append(" ]");
            return r.toString();
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }
}

