/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.type;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.brandao.brutos.MvcResponse;
import org.brandao.brutos.type.AbstractType;
import org.brandao.brutos.type.DateTimeType;
import org.brandao.brutos.type.UnknownTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDateType
extends AbstractType
implements DateTimeType {
    protected SimpleDateFormat sdf;

    public DefaultDateType(String pattern) {
        this.setPattern(pattern);
    }

    public DefaultDateType() {
    }

    @Override
    public void setPattern(String value) {
        this.sdf = new SimpleDateFormat(value);
        this.sdf.setLenient(false);
    }

    private Object toValue(String value) {
        try {
            return this.sdf.parse(value);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public Class<?> getClassType() {
        return Date.class;
    }

    @Override
    public Object convert(Object value) {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty() ? null : this.toValue((String)value);
        }
        if (value == null) {
            return null;
        }
        throw new UnknownTypeException(value.getClass().getName());
    }

    @Override
    public void show(MvcResponse response, Object value) {
        response.process(value);
    }

    @Override
    public String getPattern() {
        return this.sdf.toPattern();
    }

    @Override
    public String toString(Object value) {
        if (value instanceof Date) {
            return this.sdf.format((Date)value);
        }
        if (value instanceof String) {
            Object o = this.convert(value);
            return ((String)value).isEmpty() ? null : this.sdf.format((Date)o);
        }
        if (value == null) {
            return null;
        }
        throw new UnknownTypeException(value.getClass().getName());
    }
}

