/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.type;

import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.MvcResponse;
import org.brandao.brutos.bean.EnumUtil;
import org.brandao.brutos.type.AbstractType;
import org.brandao.brutos.type.EnumType;
import org.brandao.brutos.type.UnknownTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEnumType
extends AbstractType
implements EnumType {
    private EnumerationType type;
    private EnumUtil enumUtil;

    @Override
    public void setClassType(Class<?> classType) {
        super.setClassType(classType);
        this.enumUtil = new EnumUtil(classType);
    }

    @Override
    public Object convert(Object value) {
        try {
            if (value == null) {
                return null;
            }
            if (this.classType.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (value instanceof String) {
                String tmp = (String)value;
                if (tmp.isEmpty()) {
                    return null;
                }
                Object result = null;
                if (this.type == EnumerationType.AUTO) {
                    result = this.enumUtil.valueByIndex(tmp);
                    if (result == null) {
                        result = this.enumUtil.valueByName(tmp);
                    }
                } else {
                    result = this.type == EnumerationType.ORDINAL ? this.enumUtil.valueByIndex(tmp) : this.enumUtil.valueByName(tmp);
                }
                if (result == null) {
                    throw new UnknownTypeException("enum not found: " + this.classType.getName() + "." + value);
                }
                return result;
            }
            throw new UnknownTypeException(value.getClass().getName());
        }
        catch (UnknownTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnknownTypeException(e);
        }
    }

    @Override
    public void show(MvcResponse response, Object value) {
        response.process(value);
    }

    @Override
    public EnumerationType getEnumerationType() {
        return this.type;
    }

    @Override
    public void setEnumerationType(EnumerationType type) {
        this.type = type;
    }

    @Override
    public String toString(Object value) {
        try {
            if (value == null) {
                return null;
            }
            if (this.classType.isAssignableFrom(value.getClass())) {
                if (this.type == EnumerationType.AUTO || this.type == EnumerationType.STRING) {
                    return ((Enum)value).name();
                }
                return String.valueOf(((Enum)value).ordinal());
            }
            if (value instanceof String) {
                value = this.convert(value);
                return this.toString(value);
            }
            throw new UnknownTypeException(value.getClass().getName());
        }
        catch (UnknownTypeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnknownTypeException(e);
        }
    }
}

