/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.type;

import org.brandao.brutos.BrutosException;
import org.brandao.brutos.type.Type;
import org.brandao.brutos.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeFactory
implements TypeFactory {
    private Class<?> type;
    private Class<?> classType;

    public DefaultTypeFactory(Class<?> type, Class<?> classType) {
        if (!Type.class.isAssignableFrom(type)) {
            throw new BrutosException("invalid class type: " + type.getName());
        }
        this.type = type;
        this.classType = classType;
    }

    @Override
    public Type getInstance() {
        try {
            return (Type)this.type.newInstance();
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    @Override
    public Class<?> getClassType() {
        return this.classType;
    }

    @Override
    public boolean matches(Class<?> type) {
        return type == this.classType;
    }
}

