/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.type;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.brandao.brutos.ConfigurableApplicationContext;
import org.brandao.brutos.ConfigurableResultAction;
import org.brandao.brutos.MutableMvcRequest;
import org.brandao.brutos.MvcResponse;
import org.brandao.brutos.RenderView;
import org.brandao.brutos.ResourceAction;
import org.brandao.brutos.StackRequestElement;
import org.brandao.brutos.TypeManager;
import org.brandao.brutos.ViewResolver;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.type.AbstractType;
import org.brandao.brutos.type.Type;
import org.brandao.brutos.type.UnknownTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultActionType
extends AbstractType {
    private final ConcurrentMap<Class<?>, Type> cache = new ConcurrentHashMap();

    @Override
    public Object convert(Object value) {
        return value;
    }

    @Override
    public void show(MvcResponse response, Object value) {
        MutableMvcRequest request = (MutableMvcRequest)response.getRequest();
        ConfigurableResultAction resultAction = (ConfigurableResultAction)value;
        Map<String, Object> header = resultAction.getHeader();
        Map<String, Object> vars = resultAction.getVars();
        Object content = resultAction.getContent();
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)request.getRequestInstrument().getContext();
        for (String key : header.keySet()) {
            response.setHeader(key, header.get(key));
        }
        for (String key : vars.keySet()) {
            request.setProperty(key, vars.get(key));
        }
        if (content != null) {
            Type contentType = this.getContentType(resultAction.getContentType(), context);
            contentType.show(response, content);
            return;
        }
        RenderView renderView = context.getRenderView();
        StackRequestElement stackRequestElement = request.getStackRequestElement();
        String view = this.getView(resultAction, request.getResourceAction(), context.getViewResolver());
        stackRequestElement.setView(view);
        renderView.show(response.getRequest(), response);
    }

    private String getView(ConfigurableResultAction resultAction, ResourceAction resourceAction, ViewResolver viewResolver) {
        String view = resultAction.getView();
        boolean resolved = resultAction.isResolvedView();
        Action action = resourceAction.getMethodForm();
        view = resolved ? view : viewResolver.getActionView(action.getController().getClassType(), action.getExecutor(), view);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type getContentType(Class<?> contentType, ConfigurableApplicationContext context) {
        Type type = (Type)this.cache.get(contentType);
        if (type != null) {
            return type;
        }
        ResultActionType resultActionType = this;
        synchronized (resultActionType) {
            type = (Type)this.cache.get(contentType);
            if (type != null) {
                return type;
            }
            TypeManager typeManager = context.getTypeManager();
            type = typeManager.getType(contentType);
            if (contentType == null) {
                throw new UnknownTypeException();
            }
            this.cache.put(contentType, type);
            return type;
        }
    }

    @Override
    public boolean isAlwaysRender() {
        return true;
    }
}

