/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.brandao.brutos.BrutosConstants;
import org.brandao.brutos.EnumerationType;
import org.brandao.brutos.ResultAction;
import org.brandao.brutos.TypeManager;
import org.brandao.brutos.type.ArrayType;
import org.brandao.brutos.type.BigDecimalType;
import org.brandao.brutos.type.BigIntegerType;
import org.brandao.brutos.type.BooleanType;
import org.brandao.brutos.type.BooleanWrapperType;
import org.brandao.brutos.type.ByteType;
import org.brandao.brutos.type.ByteWrapperType;
import org.brandao.brutos.type.CalendarType;
import org.brandao.brutos.type.CharType;
import org.brandao.brutos.type.CharacterType;
import org.brandao.brutos.type.ClassType;
import org.brandao.brutos.type.CollectionType;
import org.brandao.brutos.type.DateTimeType;
import org.brandao.brutos.type.DefaultArrayTypeFactory;
import org.brandao.brutos.type.DefaultDateType;
import org.brandao.brutos.type.DefaultEnumTypeFactory;
import org.brandao.brutos.type.DefaultTypeFactory;
import org.brandao.brutos.type.DoubleType;
import org.brandao.brutos.type.DoubleWrapperType;
import org.brandao.brutos.type.EnumType;
import org.brandao.brutos.type.FloatType;
import org.brandao.brutos.type.FloatWrapperType;
import org.brandao.brutos.type.GenericType;
import org.brandao.brutos.type.IntegerType;
import org.brandao.brutos.type.IntegerWrapperType;
import org.brandao.brutos.type.ListType;
import org.brandao.brutos.type.LongType;
import org.brandao.brutos.type.LongWrapperType;
import org.brandao.brutos.type.ObjectTypeFactory;
import org.brandao.brutos.type.ResultActionType;
import org.brandao.brutos.type.SerializableType;
import org.brandao.brutos.type.SetType;
import org.brandao.brutos.type.ShortType;
import org.brandao.brutos.type.ShortWrapperType;
import org.brandao.brutos.type.StringType;
import org.brandao.brutos.type.Type;
import org.brandao.brutos.type.TypeFactory;
import org.brandao.brutos.type.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManagerImp
implements TypeManager {
    private final List<TypeFactory> defaultTypes;
    private final List<TypeFactory> customTypes = new LinkedList<TypeFactory>();
    private final ConcurrentMap<Class<?>, TypeFactory> cache = new ConcurrentHashMap();

    public TypeManagerImp() {
        this.defaultTypes = new LinkedList<TypeFactory>();
        this.defaultTypes.add(new DefaultTypeFactory(BooleanType.class, Boolean.TYPE));
        this.defaultTypes.add(new DefaultTypeFactory(ByteType.class, Byte.TYPE));
        this.defaultTypes.add(new DefaultTypeFactory(CharType.class, Character.TYPE));
        this.defaultTypes.add(new DefaultTypeFactory(DoubleType.class, Double.TYPE));
        this.defaultTypes.add(new DefaultTypeFactory(FloatType.class, Float.TYPE));
        this.defaultTypes.add(new DefaultTypeFactory(IntegerType.class, Integer.TYPE));
        this.defaultTypes.add(new DefaultTypeFactory(LongType.class, Long.TYPE));
        this.defaultTypes.add(new DefaultTypeFactory(ShortType.class, Short.TYPE));
        this.defaultTypes.add(new DefaultTypeFactory(StringType.class, String.class));
        this.defaultTypes.add(new DefaultTypeFactory(BooleanWrapperType.class, Boolean.class));
        this.defaultTypes.add(new DefaultTypeFactory(ByteWrapperType.class, Byte.class));
        this.defaultTypes.add(new DefaultTypeFactory(CharacterType.class, Character.class));
        this.defaultTypes.add(new DefaultTypeFactory(DoubleWrapperType.class, Double.class));
        this.defaultTypes.add(new DefaultTypeFactory(FloatWrapperType.class, Float.class));
        this.defaultTypes.add(new DefaultTypeFactory(IntegerWrapperType.class, Integer.class));
        this.defaultTypes.add(new DefaultTypeFactory(LongWrapperType.class, Long.class));
        this.defaultTypes.add(new DefaultTypeFactory(ShortWrapperType.class, Short.class));
        this.defaultTypes.add(new DefaultTypeFactory(ListType.class, List.class));
        this.defaultTypes.add(new DefaultTypeFactory(SetType.class, Set.class));
        this.defaultTypes.add(new DefaultTypeFactory(SerializableType.class, Serializable.class));
        this.defaultTypes.add(new DefaultTypeFactory(DefaultDateType.class, Date.class));
        this.defaultTypes.add(new DefaultTypeFactory(CalendarType.class, Calendar.class));
        this.defaultTypes.add(new DefaultTypeFactory(BigDecimalType.class, BigDecimal.class));
        this.defaultTypes.add(new DefaultTypeFactory(BigIntegerType.class, BigInteger.class));
        this.defaultTypes.add(new DefaultArrayTypeFactory());
        this.defaultTypes.add(new DefaultEnumTypeFactory());
        this.defaultTypes.add(new DefaultTypeFactory(ClassType.class, Class.class));
        this.defaultTypes.add(new DefaultTypeFactory(ResultActionType.class, ResultAction.class));
        this.defaultTypes.add(new ObjectTypeFactory());
    }

    @Override
    public void register(TypeFactory factory) {
        this.customTypes.add(factory);
        this.cache.clear();
    }

    @Override
    public void remove(Class<?> type) {
        Object factory;
        ArrayList<TypeFactory> factoryToRemove = new ArrayList<TypeFactory>();
        for (TypeFactory factory2 : this.customTypes) {
            if (factory2.getClassType() != type) continue;
            factoryToRemove.add(factory2);
        }
        for (int k = 0; k < factoryToRemove.size(); ++k) {
            factory = factoryToRemove.get(k);
            this.customTypes.remove(factory);
        }
        factoryToRemove.clear();
        for (TypeFactory factory3 : this.defaultTypes) {
            if (factory3.getClassType() != type) continue;
            factoryToRemove.add(factory3);
        }
        for (int k = 0; k < factoryToRemove.size(); ++k) {
            factory = factoryToRemove.get(k);
            this.defaultTypes.remove(factory);
        }
        this.cache.clear();
    }

    @Override
    public void remove(TypeFactory factory) {
        this.customTypes.remove(factory);
        this.cache.clear();
    }

    @Override
    public List<TypeFactory> getAllTypes() {
        return this.customTypes;
    }

    @Override
    public boolean isStandardType(Class<?> clazz) {
        TypeFactory typeFactory = this.getTypeFactory(clazz);
        return clazz == Object.class && typeFactory != null || typeFactory != null && typeFactory.getClassType() != Object.class;
    }

    @Override
    public Type getType(Object classType) {
        return this.getType(classType, BrutosConstants.DEFAULT_ENUMERATIONTYPE, "yyyy-MM-dd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeFactory getTypeFactory(Object classType) {
        TypeFactory factory = (TypeFactory)this.cache.get(classType);
        if (factory != null) {
            return factory;
        }
        TypeManagerImp typeManagerImp = this;
        synchronized (typeManagerImp) {
            factory = (TypeFactory)this.cache.get(classType);
            if (factory != null) {
                return factory;
            }
            factory = this.getInternalTypeFactory(classType);
            this.cache.put((Class)classType, factory);
            return factory;
        }
    }

    private TypeFactory getInternalTypeFactory(Object classType) {
        Class rawType = TypeUtil.getRawType(classType);
        for (TypeFactory factory : this.customTypes) {
            if (!factory.matches(rawType)) continue;
            return factory;
        }
        for (TypeFactory factory : this.defaultTypes) {
            if (!factory.matches(rawType)) continue;
            return factory;
        }
        return null;
    }

    @Override
    public Type getType(Object classType, EnumerationType enumType, String pattern) {
        Type tmp;
        Class rawType = TypeUtil.getRawType(classType);
        TypeFactory factory = this.getTypeFactory(rawType);
        Type type = factory.getInstance();
        type.setClassType(classType instanceof Class ? (Class)classType : rawType);
        if (type instanceof EnumType) {
            tmp = (EnumType)type;
            tmp.setEnumerationType(enumType);
        }
        if (type instanceof DateTimeType) {
            tmp = (DateTimeType)type;
            tmp.setPattern(pattern);
        }
        if (type instanceof GenericType) {
            tmp = (GenericType)type;
            tmp.setParameters(TypeUtil.getParameters(classType));
            tmp.setRawClass(rawType);
        }
        if (type instanceof CollectionType) {
            Class<Object> collectionGenericType = TypeUtil.getCollectionType(classType);
            if (collectionGenericType == null) {
                collectionGenericType = Object.class;
            }
            Class collectionType = TypeUtil.getRawType(collectionGenericType);
            CollectionType tmp2 = (CollectionType)type;
            tmp2.setCollectionType(this.getType(collectionType));
        }
        if (type instanceof ArrayType) {
            tmp = (ArrayType)type;
            tmp.setComponentType(this.getType(rawType.getComponentType()));
            tmp.setRawClass(rawType);
        }
        return type;
    }
}

