/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.type;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.brandao.brutos.BrutosException;

public final class TypeUtil {
    private static Class defaultListType = ArrayList.class;
    private static Class defaultSetType = HashSet.class;
    private static Class defaultMapType = HashMap.class;
    private static Class defaultConcurrentMapType = ConcurrentHashMap.class;

    public static Class getRawType(Object type) {
        if (type == null) {
            return null;
        }
        try {
            Class<?> parameterizedTypeClass = Class.forName("java.lang.reflect.ParameterizedType");
            if (parameterizedTypeClass.isAssignableFrom(type.getClass())) {
                Method getRawType = parameterizedTypeClass.getMethod("getRawType", new Class[0]);
                Object clazz = getRawType.invoke(type, new Object[0]);
                return (Class)clazz;
            }
            if (type instanceof Class) {
                return (Class)type;
            }
            throw new BrutosException("invalid type: " + type);
        }
        catch (ClassNotFoundException ex) {
            if (type instanceof Class) {
                return (Class)type;
            }
            throw new BrutosException("invalid type: " + type);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    public static Object getCollectionType(Object type) {
        int index = -1;
        Class rawType = TypeUtil.getRawType(type);
        if (Map.class.isAssignableFrom(rawType)) {
            index = 1;
        } else if (Collection.class.isAssignableFrom(rawType)) {
            index = 0;
        }
        return TypeUtil.getParameter(type, index);
    }

    public static Object getKeyType(Object type) {
        int index = -1;
        Class rawType = TypeUtil.getRawType(type);
        if (Map.class.isAssignableFrom(rawType)) {
            index = 0;
        }
        return TypeUtil.getParameter(type, index);
    }

    public static Object getParameter(Object type, int index) {
        try {
            Object[] args = TypeUtil.getParameters(type);
            return args == null ? null : Array.get(args, index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object[] getParameters(Object type) {
        try {
            Class<?> parameterizedTypeClass = Class.forName("java.lang.reflect.ParameterizedType");
            if (parameterizedTypeClass.isAssignableFrom(type.getClass())) {
                Method getRawType = parameterizedTypeClass.getMethod("getActualTypeArguments", new Class[0]);
                Object args = getRawType.invoke(type, new Object[0]);
                return (Object[])args;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class getDefaultListType() {
        return defaultListType;
    }

    public static void setDefaultListType(Class aDefaultListType) {
        defaultListType = aDefaultListType;
    }

    public static Class getDefaultSetType() {
        return defaultSetType;
    }

    public static void setDefaultSetType(Class aDefaultSetType) {
        defaultSetType = aDefaultSetType;
    }

    public static Class getDefaultMapType() {
        return defaultMapType;
    }

    public static void setDefaultMapType(Class aDefaultMapType) {
        defaultMapType = aDefaultMapType;
    }

    public static Class getDefaultConcurrentMapType() {
        return defaultConcurrentMapType;
    }

    public static void setDefaultConcurrentMapType(Class aDefaultConcurrentMapType) {
        defaultConcurrentMapType = aDefaultConcurrentMapType;
    }
}

