/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.validator;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.mapping.Action;
import org.brandao.brutos.mapping.ConstructorArgBean;
import org.brandao.brutos.mapping.ConstructorBean;
import org.brandao.brutos.mapping.ParameterAction;
import org.brandao.brutos.mapping.PropertyBean;
import org.brandao.brutos.mapping.PropertyController;
import org.brandao.brutos.mapping.ResultAction;
import org.brandao.brutos.validator.RestrictionRules;
import org.brandao.brutos.validator.ValidationRule;
import org.brandao.brutos.validator.Validator;
import org.brandao.brutos.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidator
implements Validator {
    private Properties config;
    private Map<String, Class<? extends ValidationRule>> mappedRules;
    private Map<String, ValidationRule> rules;
    private boolean initialized;

    public DefaultValidator(Map<String, Class<? extends ValidationRule>> rules) {
        this.mappedRules = rules;
    }

    @Override
    public void configure(Properties config) {
        this.config = config;
        this.initialized = false;
    }

    private synchronized void init() {
        try {
            this.rules = new HashMap<String, ValidationRule>();
            for (String key : this.config.stringPropertyNames()) {
                Class<Object> rule;
                if (key.equals("message") || (rule = key.equalsIgnoreCase(RestrictionRules.CUSTOM.toString()) ? ClassUtil.get(this.config.getProperty(key)) : this.mappedRules.get(key)) == null) continue;
                ValidationRule ruleInstance = (ValidationRule)ClassUtil.getInstance(rule);
                ruleInstance.setConfiguration(this.config);
                this.rules.put(key, ruleInstance);
            }
            this.initialized = true;
        }
        catch (Throwable e) {
            throw new BrutosException(e);
        }
    }

    protected String getMessage(Object value, Properties config) {
        String message = config.getProperty("message");
        if (message != null) {
            for (String key : this.rules.keySet()) {
                String val = String.valueOf(config.get(key));
                message = message.replace("${" + key + "}", val);
            }
            message = message.replace("${value}", String.valueOf(value));
        } else {
            message = "";
        }
        return message;
    }

    public void innerValidate(Object source, Object value) throws ValidatorException {
        if (!this.initialized) {
            this.init();
        }
        Iterator<ValidationRule> c = this.rules.values().iterator();
        try {
            while (c.hasNext()) {
                ValidationRule rule = c.next();
                rule.validate(source, value);
            }
        }
        catch (ValidatorException e) {
            throw new ValidatorException(this.getMessage(value, this.config), e);
        }
    }

    @Override
    public Properties getConfiguration() {
        return this.config;
    }

    @Override
    public void validate(ConstructorArgBean source, Object value) throws ValidatorException {
        this.innerValidate(source, value);
    }

    @Override
    public void validate(ConstructorBean source, Object factoryInstance, Object[] value) throws ValidatorException {
    }

    @Override
    public void validate(ConstructorBean source, Object factoryInstance, Object value) throws ValidatorException {
        this.innerValidate(source, value);
    }

    @Override
    public void validate(PropertyBean source, Object beanInstance, Object value) throws ValidatorException {
        this.innerValidate(source, value);
    }

    @Override
    public void validate(PropertyController source, Object beanInstance, Object value) throws ValidatorException {
        this.innerValidate(source, value);
    }

    @Override
    public void validate(ParameterAction source, Object controllerInstance, Object value) throws ValidatorException {
        this.innerValidate(source, value);
    }

    @Override
    public void validate(Action source, Object controller, Object[] value) throws ValidatorException {
    }

    @Override
    public void validate(Action source, Object controller, Object value) throws ValidatorException {
        this.innerValidate(source, value);
    }

    public void validate(Method source, Object instance, Object[] value) throws ValidatorException {
    }

    public void validate(Method source, Object instance, Object value) throws ValidatorException {
        this.innerValidate(source, value);
    }

    @Override
    public void validate(ResultAction source, Object controller, Object value) throws ValidatorException {
        this.innerValidate(source, value);
    }
}

