/*
 * Decompiled with CFR 0.152.
 */
package org.brandao.brutos.validator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.brandao.brutos.BrutosException;
import org.brandao.brutos.ClassUtil;
import org.brandao.brutos.ValidatorFactory;
import org.brandao.brutos.validator.DefaultValidator;
import org.brandao.brutos.validator.RestrictionRules;
import org.brandao.brutos.validator.Validator;

public class DefaultValidatorFactory
implements ValidatorFactory {
    public static final String PREFIX_NAME = "org.brandao.brutos.validator.rules.";
    private Map rules;

    public void configure(Properties config) {
        this.rules = new HashMap();
        this.load(config);
    }

    private void load(Properties config) {
        List<RestrictionRules> staticRules = RestrictionRules.getRestrictionRules();
        int size = staticRules.size();
        for (int i = 0; i < size; ++i) {
            RestrictionRules ruleId = staticRules.get(i);
            if (ruleId.equals(RestrictionRules.CUSTOM)) continue;
            Class rule = this.getClass(ruleId.toString(), false);
            this.rules.put(ruleId.toString(), rule);
        }
        for (String key : config.stringPropertyNames()) {
            if (!key.startsWith(PREFIX_NAME)) continue;
            String name = key.substring(PREFIX_NAME.length(), key.length());
            Class rule = this.getClass(config.getProperty(key), true);
            this.rules.put(name.toLowerCase(), rule);
        }
    }

    private Class getClass(String name, boolean resolved) {
        try {
            String className = resolved ? name : this.getClassName(name);
            return ClassUtil.get(className);
        }
        catch (Exception e) {
            throw new BrutosException(e);
        }
    }

    private String getClassName(String name) {
        return "org.brandao.brutos.validator." + this.getCanonicalName(name) + "ValidationRule";
    }

    private String getCanonicalName(String name) {
        return Character.toString(name.charAt(0)).toUpperCase() + name.subSequence(1, name.length());
    }

    public Validator getValidator(Properties config) {
        DefaultValidator validator = new DefaultValidator(this.rules);
        validator.configure(config);
        return validator;
    }

    public void destroy() {
    }
}

